package org.unifiedpush.distributor.nextpush.activities

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import org.unifiedpush.distributor.nextpush.EventBus

class UiAction(val type: Type) {
    enum class Type {
        RefreshRegistrations
    }

    fun handle(action: (Type) -> Unit) {
        action(type)
    }

    companion object {
        fun publish(type: Type) {
            CoroutineScope(Dispatchers.IO).launch {
                EventBus.publish(UiAction(type))
            }
        }
    }
}
