package org.unifiedpush.distributor.nextpush.activities

import android.app.Application
import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import android.os.Build
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.lifecycle.ViewModel
import org.unifiedpush.distributor.nextpush.account.AccountFactory
import org.unifiedpush.distributor.nextpush.activities.ui.StartUiState

class StartViewModel(state: StartUiState? = null, val application: Application? = null) : ViewModel() {

    var state by mutableStateOf(state)
        private set

    fun setLoginSSO() {
        application?.let {
            AccountFactory.setTypeSSO(it)
        }
    }

    fun setLoginDirect(state: StartUiState) {
        application?.let {
            AccountFactory.setTypeDirect(it, state.server, state.username, state.password)
        }
    }

    fun setLoginFromClipboard() {
        application ?: return
        val clipboard = application.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager

        if (clipboard.hasPrimaryClip()) {
            val clipData = clipboard.primaryClip
            val clipText = clipData?.getItemAt(0)?.text.toString()

            val regex = """nc://login/user:(.+)&password:(.+)&server:(.+)""".toRegex()

            regex.find(clipText)?.let {
                val username = it.groupValues[1]
                val password = it.groupValues[2]
                val server = it.groupValues[3]
                state = StartUiState(username, password, server)
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                    clipboard.clearPrimaryClip()
                } else {
                    clipboard.setPrimaryClip(ClipData.newPlainText("clear", ""))
                }
            }
        }
    }
}
