package org.unifiedpush.distributor.nextpush.activities

import android.app.Application
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.launch
import org.unifiedpush.distributor.nextpush.activities.ui.SettingsState

class SettingsViewModel(state: SettingsState, val application: Application? = null) : ViewModel() {
    constructor(application: Application) : this(
        SettingsState(application),
        application
    )

    var state by mutableStateOf(state)
        private set

    fun toggleShowToasts() {
        viewModelScope.launch {
            state = state.copy(showToasts = !state.showToasts)
            publishAction(AppAction(AppAction.Type.ShowToasts(state.showToasts)))
        }
    }
}
