package org.unifiedpush.distributor.nextpush.activities

import android.content.Context
import org.unifiedpush.android.distributor.ui.compose.state.RegistrationListState
import org.unifiedpush.android.distributor.ui.compose.state.RegistrationState
import org.unifiedpush.distributor.Database
import org.unifiedpush.distributor.nextpush.DatabaseFactory

fun getRegistrationListState(context: Context): RegistrationListState = RegistrationListState(
    list = DatabaseFactory.getDb(context).listApps().map { app ->
        getRegistrationState(context, app)
    }
)

fun getRegistrationState(context: Context, app: Database.App): RegistrationState = app.isLocal(context).let { local ->
    RegistrationState(
        app = if (local) {
            context.localApplicationRowState(app)
        } else {
            context.applicationRowState(app)
        },
        msgCount = app.msgCount,
        token = app.connectorToken,
        copyable = local
    )
}
