package org.unifiedpush.distributor.nextpush.account

import android.content.Context
import org.unifiedpush.distributor.Store
import org.unifiedpush.distributor.nextpush.AppStore

class DirectAccountStore(context: Context) : Store(context, AppStore.PREF_NAME) {
    var url: String?
        get() = sharedPreferences
            .getString(PREF_URL, null)
        set(value) = sharedPreferences
            .edit().putOrRemove(PREF_URL, value).apply()

    var username: String?
        get() = sharedPreferences
            .getString(PREF_USERNAME, null)
        set(value) = sharedPreferences
            .edit().putOrRemove(PREF_USERNAME, value).apply()

    var password: String?
        get() = sharedPreferences
            .getString(PREF_PASSWORD, null)
        set(value) = sharedPreferences
            .edit().putOrRemove(PREF_PASSWORD, value).apply()

    var connected: Boolean
        get() = sharedPreferences
            .getBoolean(PREF_CONNECTED, false)
        set(value) = sharedPreferences
            .edit().putBoolean(PREF_CONNECTED, value)
            .apply()

    override fun wipe() {
        url = null
        username = null
        password = null
        connected = false
    }

    companion object {
        private const val PREF_CONNECTED = "direct_account::connected"
        private const val PREF_URL = "direct_account::url"
        private const val PREF_USERNAME = "direct_account::username"
        private const val PREF_PASSWORD = "direct_account::password"
    }
}
