package org.unifiedpush.distributor.nextpush.account

import android.content.Context
import android.util.Log
import org.unifiedpush.distributor.nextpush.utils.TAG

object AccountFactory {
    private var account: Account<out Any>? = null

    fun getAccount(context: Context, connected: Boolean = true): Account<out Any>? = account
        ?: run {
            val accountType = AccountStore(context).accountType
            Log.d(TAG, "New account, type=$accountType")
            when (accountType) {
                AccountType.SSO -> SSOAccount(context)
                AccountType.Direct -> DirectAccount(context)
            }.takeIf { !connected || it.connected }.also {
                if (connected) {
                    account = it
                }
            }
        }

    fun logout(context: Context) {
        getAccount(context)?.logout(context)
        account = null
    }

    fun setTypeSSO(context: Context) {
        account = null
        AccountStore(context).accountType = AccountType.SSO
        DirectAccountStore(context).wipe() // Just in case
    }

    fun setTypeDirect(
        context: Context,
        url: String,
        username: String,
        password: String
    ) {
        account = null
        AccountStore(context).accountType = AccountType.Direct
        DirectAccount.setCredentials(context, url, username, password)
    }
}
