package org.unifiedpush.distributor.nextpush.account

import android.app.Activity
import android.content.Context
import android.content.Intent

interface Account<T> {
    /** Nextcloud username. */
    val name: String?

    /** Nextcloud instance url. */
    val url: String?

    /** Are we connected to nextcloud ? */
    var connected: Boolean

    /** Connect to nextcloud. */
    fun connect(activity: Activity)

    /**
     * Invoked after [connect].
     *
     * Used to import nextcloud account after linking to Nextcloud app
     */
    fun onActivityResult(
        activity: Activity,
        requestCode: Int,
        resultCode: Int,
        data: Intent?,
        block: (success: Boolean) -> Unit
    )

    /** Get client used to request the server. */
    fun getClient(context: Context): T?

    /** Logout. */
    fun logout(context: Context)
}
