/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import AsyncStorage from "@react-native-async-storage/async-storage";

export interface Settings {
  showWelcome: boolean;
}

export const defaultSettings = {
  showWelcome: true,
};

export async function loadSettings() {
  const v = await AsyncStorage.getItem("settings");
  // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
  const settingsStored = v ? JSON.parse(v) : {};
  const settings: Settings = defaultSettings;
  Object.assign(settings, settingsStored);
  return settings;
}

export async function storeSettings(s: Settings) {
  return AsyncStorage.setItem("settings", JSON.stringify(s));
}
