/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import { MigrationInterface, QueryRunner } from "typeorm";

export class Create1758570485790 implements MigrationInterface {
  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `CREATE TABLE "protocols" ("id" integer PRIMARY KEY AUTOINCREMENT NOT NULL, "createdDate" datetime NOT NULL DEFAULT (CURRENT_TIMESTAMP), "callResult" integer NOT NULL, "remark" text, "therapistId" integer)`,
    );
    await queryRunner.query(
      `CREATE TABLE "therapists" ("id" integer PRIMARY KEY AUTOINCREMENT NOT NULL, "title" text, "name" text, "specialism" text, "street" text, "house_number" text, "zip" text, "city" text, "country" text, "lat" integer, "lon" integer, "phone" text, "mobile" text, "email" text, "website" text, "is_searchable" boolean, "insurrance_approved" boolean, "datasource" text, "databaseId" text, "enabled" boolean NOT NULL)`,
    );
    await queryRunner.query(
      `CREATE TABLE "timeslots" ("id" integer PRIMARY KEY AUTOINCREMENT NOT NULL, "day_of_week" text NOT NULL, "start_hour" integer NOT NULL, "start_minute" integer NOT NULL, "end_hour" integer NOT NULL, "end_minute" integer NOT NULL, "therapistId" integer)`,
    );
    await queryRunner.query(
      `CREATE TABLE "temporary_protocols" ("id" integer PRIMARY KEY AUTOINCREMENT NOT NULL, "createdDate" datetime NOT NULL DEFAULT (CURRENT_TIMESTAMP), "callResult" integer NOT NULL, "remark" text, "therapistId" integer, CONSTRAINT "FK_b79077c3e6c66d6dbf2593dae3a" FOREIGN KEY ("therapistId") REFERENCES "therapists" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION)`,
    );
    await queryRunner.query(
      `INSERT INTO "temporary_protocols"("id", "createdDate", "callResult", "remark", "therapistId") SELECT "id", "createdDate", "callResult", "remark", "therapistId" FROM "protocols"`,
    );
    await queryRunner.query(`DROP TABLE "protocols"`);
    await queryRunner.query(
      `ALTER TABLE "temporary_protocols" RENAME TO "protocols"`,
    );
    await queryRunner.query(
      `CREATE TABLE "temporary_timeslots" ("id" integer PRIMARY KEY AUTOINCREMENT NOT NULL, "day_of_week" text NOT NULL, "start_hour" integer NOT NULL, "start_minute" integer NOT NULL, "end_hour" integer NOT NULL, "end_minute" integer NOT NULL, "therapistId" integer, CONSTRAINT "FK_45dbfa8ce3b119a39ce6bbfbcc1" FOREIGN KEY ("therapistId") REFERENCES "therapists" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION)`,
    );
    await queryRunner.query(
      `INSERT INTO "temporary_timeslots"("id", "day_of_week", "start_hour", "start_minute", "end_hour", "end_minute", "therapistId") SELECT "id", "day_of_week", "start_hour", "start_minute", "end_hour", "end_minute", "therapistId" FROM "timeslots"`,
    );
    await queryRunner.query(`DROP TABLE "timeslots"`);
    await queryRunner.query(
      `ALTER TABLE "temporary_timeslots" RENAME TO "timeslots"`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "timeslots" RENAME TO "temporary_timeslots"`,
    );
    await queryRunner.query(
      `CREATE TABLE "timeslots" ("id" integer PRIMARY KEY AUTOINCREMENT NOT NULL, "day_of_week" text NOT NULL, "start_hour" integer NOT NULL, "start_minute" integer NOT NULL, "end_hour" integer NOT NULL, "end_minute" integer NOT NULL, "therapistId" integer)`,
    );
    await queryRunner.query(
      `INSERT INTO "timeslots"("id", "day_of_week", "start_hour", "start_minute", "end_hour", "end_minute", "therapistId") SELECT "id", "day_of_week", "start_hour", "start_minute", "end_hour", "end_minute", "therapistId" FROM "temporary_timeslots"`,
    );
    await queryRunner.query(`DROP TABLE "temporary_timeslots"`);
    await queryRunner.query(
      `ALTER TABLE "protocols" RENAME TO "temporary_protocols"`,
    );
    await queryRunner.query(
      `CREATE TABLE "protocols" ("id" integer PRIMARY KEY AUTOINCREMENT NOT NULL, "createdDate" datetime NOT NULL DEFAULT (CURRENT_TIMESTAMP), "callResult" integer NOT NULL, "remark" text, "therapistId" integer)`,
    );
    await queryRunner.query(
      `INSERT INTO "protocols"("id", "createdDate", "callResult", "remark", "therapistId") SELECT "id", "createdDate", "callResult", "remark", "therapistId" FROM "temporary_protocols"`,
    );
    await queryRunner.query(`DROP TABLE "temporary_protocols"`);
    await queryRunner.query(`DROP TABLE "timeslots"`);
    await queryRunner.query(`DROP TABLE "therapists"`);
    await queryRunner.query(`DROP TABLE "protocols"`);
  }
}
