/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import {
  Entity,
  Column,
  BaseEntity,
  OneToMany,
  PrimaryGeneratedColumn,
} from "typeorm";
import TimeslotEntity from "./TimeslotEntity";
import ProtocolEntity from "./ProtocolEntity";

@Entity({ name: "therapists" })
export default class TherapistEntity extends BaseEntity {
  //TODO: the type should be inferred by typeorm for all attributes
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: "text", nullable: true })
  title: string | null;

  @Column({ type: "text", nullable: true })
  name: string | null;

  @Column({ type: "text", nullable: true })
  specialism: string | null;

  @Column({ type: "text", nullable: true })
  street: string | null;

  @Column({ type: "text", nullable: true })
  house_number: string | null;

  @Column({ type: "text", nullable: true })
  zip: string | null;

  @Column({ type: "text", nullable: true })
  city: string | null;

  @Column({ type: "text", nullable: true })
  country: string | null;

  @Column({ type: "int", nullable: true })
  lat: number | null;

  @Column({ type: "int", nullable: true })
  lon: number | null;

  @Column({ type: "text", nullable: true })
  phone: string | null;

  @Column({ type: "text", nullable: true })
  mobile: string | null;

  @Column({ type: "text", nullable: true })
  email: string | null;

  @Column({ type: "text", nullable: true })
  website: string | null;

  @Column({ type: "boolean", nullable: true })
  is_searchable: boolean | null;

  @Column({ type: "boolean", nullable: true })
  insurrance_approved: boolean | null;

  @Column({ type: "text", nullable: true })
  datasource: string | null;

  @Column({ type: "text", nullable: true })
  databaseId: string | null;

  @OneToMany(() => TimeslotEntity, (timeslot) => timeslot.therapist, {
    cascade: true,
  })
  timeslots: TimeslotEntity[];

  @OneToMany(() => ProtocolEntity, (p) => p.therapist, {
    cascade: true,
  })
  protocolEntries: ProtocolEntity[];

  @Column({ type: "boolean" })
  enabled: boolean;
}
