/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import {
  BaseEntity,
  Column,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
} from "typeorm";
import TherapistEntity from "./TherapistEntity";

@Entity({ name: "protocols" })
export default class ProtocolEntity extends BaseEntity {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: "datetime", default: () => "CURRENT_TIMESTAMP" })
  createdDate: Date;

  @Column({ type: "int" })
  callResult: number;

  @Column({ type: "text", nullable: true })
  remark: string | null;

  @ManyToOne(() => TherapistEntity, (therapist) => therapist.protocolEntries, {
    orphanedRowAction: "delete",
  })
  therapist: TherapistEntity;
}
