/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

export enum CallResult {
  SUCCESS = 0,
  CALL_AGAIN,
  ANSWERING_MACHINE_LEFT_MESSAGE,
  ANSWERING_MACHINE_NO_MESSAGE,
  TIMESLOTS_CHANGED,
  LINE_BUSY,
  NO_ANSWER,
  NO_SUCCESS_OTHER,
  NO_SUCCESS_NO_APPOINTMENTS_AVAILABLE,
}

export const CallResultLabels = [
  { key: CallResult.SUCCESS, value: "Ich habe einen Termin erhalten." },
  { key: CallResult.CALL_AGAIN, value: "Ich wurde um erneuten Anruf gebeten." },
  {
    key: CallResult.ANSWERING_MACHINE_LEFT_MESSAGE,
    value: "Anrufbeantworter. Ich habe eine Nachricht hinterlassen.",
  },
  {
    key: CallResult.ANSWERING_MACHINE_NO_MESSAGE,
    value: "Anrufbeantworter. Ich habe keine Nachricht hinterlassen.",
  },
  {
    key: CallResult.TIMESLOTS_CHANGED,
    value: "Die Telefonzeiten wurden geändert.",
  },
  { key: CallResult.LINE_BUSY, value: "Es war besetzt." },
  { key: CallResult.NO_ANSWER, value: "Ich habe keine Antwort bekommen." },
  {
    key: CallResult.NO_SUCCESS_OTHER,
    value: "Ich hatte keinen Erfolg aus einem anderen Grund.",
  },
  {
    key: CallResult.NO_SUCCESS_NO_APPOINTMENTS_AVAILABLE,
    value: "Ich hatte keinen Erfolg, es sind keine Termine verfügbar.",
  },
];
