/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * component used in call view to divide timeslots
 */

import { GestureResponderEvent, StyleSheet, View } from "react-native";
import { useTheme, Text, List } from "react-native-paper";

export interface TherapistListEntryProps {
  name: string;
  bottomText?: string;
  bubbleText?: string;
  hideBorderBottom?: boolean;
  onPress?: ((event: GestureResponderEvent) => void) | undefined;

  // leftContent?: React.ReactNode | ((reset: () => void) => React.ReactNode);
  // rightContent?: React.ReactNode | ((reset: () => void) => React.ReactNode);
}

export default function TherapistListEntry(props: TherapistListEntryProps) {
  const theme = useTheme();
  return (
    <>
      <List.Item
        onPress={props.onPress}
        style={{
          backgroundColor: theme.colors.background,
          borderBottomColor: theme.colors.outline,
          ...styles.container,
          ...(!!props.hideBorderBottom && { borderBottomWidth: 0 }),
        }}
        title={props.name}
        description={props.bottomText ?? undefined}
        right={(_) =>
          props.bubbleText ? (
            <View
              style={{
                backgroundColor: theme.colors.primary,
                ...styles.bubble,
              }}
            >
              <Text
                style={{
                  color: theme.colors.onPrimary,
                  ...styles.bubbleText,
                }}
              >
                {props.bubbleText}
              </Text>
            </View>
          ) : undefined
        }
        // leftContent={props.leftContent}
        // rightContent={props.rightContent}
      />
    </>
  );
}

const styles = StyleSheet.create({
  container: { width: "100%", borderBottomWidth: 0 },
  row: { flexDirection: "row" },
  textContainer: {
    justifyContent: "center",
    maxWidth: "80%",
    flexGrow: 1,
    minHeight: 60,
    padding: 5,
  },
  nameText: { fontSize: 18 },
  bottomText: { fontSize: 15 },
  bubble: {
    marginRight: 5,
    borderRadius: 15,
    paddingHorizontal: 8,
    justifyContent: "center",
    height: 23,
  },
  bubbleText: { fontSize: 12 },
});
