/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import { Platform, StyleSheet, ScrollView } from "react-native";
import { Text, Button } from "react-native-paper";
import { useState } from "react";
import NotificationPermissionButton from "@/components/NotificationPermissionButton";
import AlarmPermissionButton from "@/components/AlarmPermissionButton";

export default function Welcome({ dismiss }: { dismiss: () => void }) {
  const [notificationPermission, setNotificationPermission] = useState(false);
  const [alarmPermission, setAlarmPermission] = useState(false);

  return (
    <ScrollView style={styles.container}>
      <Text
        style={{ textAlign: "center", ...styles.text }}
        variant="headlineSmall"
      >
        Willkommen!
      </Text>

      <Text variant="bodyMedium" style={styles.text}>
        Diese App soll dich auf der Suche nach einem Psychotherapieplatz
        unterstützen.
        {"\n"}
        Das Prinzip ist folgendes: du suchst dir Telefonzeiten und Kontakdaten
        von Therapeut*innen in deiner Umgebung heraus und trägst diese in die
        App ein. Nun wird dir angezeigt, welche Therapeut*innen jetzt gerade
        erreichbar sind und du kannst sie über die App anrufen oder ihnen eine
        E-mail schreiben.
        {"\n"}
        Nach einem Kontakt kannst du diesen gleich in der App protokollieren.
        Die Protokolle kannst du jederzeit als Pdf aus der App exportieren, um
        sie für ein Kostenerstattungsverfahren einzureichen.
        {"\n"}
        Derzeit ist die App noch in einem Teststadium. Bitte nutze regelmäßig
        die Backup Funktion in den Einstellungen um sicherzugehen, dass keine
        Daten verloren gehen. Hilf uns, in dem du auf Probleme hinweist unter
        https://codeberg.org/Therapiefinder/Therapiefinder/issues oder per mail
        an finn@landweber.xzy.
      </Text>

      <>
        <Text variant="bodyMedium" style={styles.text}>
          Wenn du benachrichtigt werden möchtest, wenn Therapeut*innen
          erreichbar sind, dann brauchen wir die folgenden Berechtigungen:
        </Text>
        <NotificationPermissionButton
          notificationPermission={notificationPermission}
          setNotificationPermission={setNotificationPermission}
          style={styles.button}
        />
        {Platform.OS === "android" && (
          <AlarmPermissionButton
            alarmPermission={alarmPermission}
            setAlarmPermission={setAlarmPermission}
            style={styles.button}
          />
        )}
      </>

      <Text variant="bodyMedium" style={styles.text}>
        Die App läuft nur auf deinem Gerät und teilt keine Daten mit uns oder
        Dritten.
      </Text>

      <Button
        style={{
          ...styles.button,
          justifyContent: "flex-end",
          marginRight: 25,
        }}
        onPress={dismiss}
      >
        Schließen
      </Button>
    </ScrollView>
  );
}

const styles = StyleSheet.create({
  container: { flex: 1 },
  button: {
    marginTop: 5,
    justifyContent: "center",
    flexDirection: "row",
    paddingBottom: 5,
  },
  text: { paddingHorizontal: 25, marginTop: 15, marginBottom: 5 },
});
