# @turf/unkink-polygon

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## unkinkPolygon

Takes a kinked polygon and returns a feature collection of polygons that have
no kinks.

Uses [simplepolygon][1] internally.

### Parameters

*   `geojson` **([FeatureCollection][2]<([Polygon][3] | [MultiPolygon][4])> | [Feature][5]<([Polygon][3] | [MultiPolygon][4])> | [Polygon][3] | [MultiPolygon][4])** polygons to unkink

### Examples

```javascript
const poly = turf.polygon([[[0, 0], [2, 0], [0, 2], [2, 2], [0, 0]]]);

const result = turf.unkinkPolygon(poly);

//addToMap
const addToMap = [poly, result]
```

Returns **[FeatureCollection][2]<[Polygon][3]>** Unkinked polygons

[1]: https://github.com/mclaeysb/simplepolygon

[2]: https://tools.ietf.org/html/rfc7946#section-3.3

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/unkink-polygon
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
