# @turf/tesselate

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## tesselate

Tesselates a polygon or multipolygon into a collection of triangle polygons
using [earcut][1].

### Parameters

*   `poly` **[Feature][2]<([Polygon][3] | [MultiPolygon][4])>** the polygon to tesselate

### Examples

```javascript
const poly = turf.polygon([[[11, 0], [22, 4], [31, 0], [31, 11], [21, 15], [11, 11], [11, 0]]]);
const triangles = turf.tesselate(poly);

//addToMap
const addToMap = [poly, triangles]
```

Returns **[FeatureCollection][5]<[Polygon][3]>** collection of polygon tesselations

[1]: https://github.com/mapbox/earcut

[2]: https://tools.ietf.org/html/rfc7946#section-3.2

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[5]: https://tools.ietf.org/html/rfc7946#section-3.3

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/tesselate
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
