# @turf/shortest-path

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## shortestPath

Returns the shortest [path][1] from [start][2] to [end][2] without colliding with
any [Feature][3] in obstacles [FeatureCollection][4]<[Polygon][5]>

### Parameters

*   `start` **[Coord][6]** point
*   `end` **[Coord][6]** point
*   `options` **[Object][7]** optional parameters (optional, default `{}`)

    *   `options.obstacles` **([Polygon][5] | [Feature][3]<[Polygon][5]> | [FeatureCollection][4]<[Polygon][5]>)?** areas which path cannot travel
    *   `options.units` **Units** unit in which resolution & minimum distance will be expressed in; it can be degrees, radians, miles, kilometers, ... (optional, default `'kilometers'`)
    *   `options.resolution` **[number][8]** distance between matrix points on which the path will be calculated (optional, default `100`)

### Examples

```javascript
var start = [-5, -6];
var end = [9, -6];
var options = {
  obstacles: turf.polygon([[[0, -7], [5, -7], [5, -3], [0, -3], [0, -7]]]).geometry
};

var path = turf.shortestPath(start, end, options);

//addToMap
var addToMap = [start, end, options.obstacles, path];
```

Returns **[Feature][3]<[LineString][1]>** shortest path between start and end

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[3]: https://tools.ietf.org/html/rfc7946#section-3.2

[4]: https://tools.ietf.org/html/rfc7946#section-3.3

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/shortest-path
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
