# @turf/sector

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## sector

Creates a circular sector of a circle of given radius and center [Point][1],
between (clockwise) bearing1 and bearing2; 0 bearing is North of center point, positive clockwise.

### Parameters

*   `center` **[Coord][2]** center point
*   `radius` **[number][3]** radius of the circle
*   `bearing1` **[number][3]** angle, in decimal degrees, of the first radius of the sector
*   `bearing2` **[number][3]** angle, in decimal degrees, of the second radius of the sector
*   `options` **[Object][4]** Optional parameters (optional, default `{}`)

    *   `options.units` **[string][5]** miles, kilometers, degrees, or radians (optional, default `'kilometers'`)
    *   `options.steps` **[number][3]** number of steps (optional, default `64`)
    *   `options.properties` **Properties** Translate properties to Feature Polygon (optional, default `{}`)

### Examples

```javascript
var center = turf.point([-75, 40]);
var radius = 5;
var bearing1 = 25;
var bearing2 = 45;

var sector = turf.sector(center, radius, bearing1, bearing2);

//addToMap
var addToMap = [center, sector];
```

Returns **[Feature][6]<[Polygon][7]>** sector polygon

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[6]: https://tools.ietf.org/html/rfc7946#section-3.2

[7]: https://tools.ietf.org/html/rfc7946#section-3.1.6

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/sector
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
