"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _clone = require('@turf/clone');
var _booleanclockwise = require('@turf/boolean-clockwise');
var _meta = require('@turf/meta');
var _invariant = require('@turf/invariant');
var _helpers = require('@turf/helpers');
function rewind(geojson, options = {}) {
  var _a, _b;
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  const mutate = (_a = options.mutate) != null ? _a : false;
  const reverse = (_b = options.reverse) != null ? _b : false;
  if (!geojson) throw new Error("<geojson> is required");
  if (typeof reverse !== "boolean")
    throw new Error("<reverse> must be a boolean");
  if (typeof mutate !== "boolean")
    throw new Error("<mutate> must be a boolean");
  if (!mutate && geojson.type !== "Point" && geojson.type !== "MultiPoint") {
    geojson = _clone.clone.call(void 0, geojson);
  }
  const results = [];
  switch (geojson.type) {
    case "GeometryCollection":
      _meta.geomEach.call(void 0, geojson, function(geometry) {
        rewindFeature(geometry, reverse);
      });
      return geojson;
    case "FeatureCollection":
      _meta.featureEach.call(void 0, geojson, function(feature) {
        const rewoundFeature = rewindFeature(feature, reverse);
        _meta.featureEach.call(void 0, rewoundFeature, function(result) {
          results.push(result);
        });
      });
      return _helpers.featureCollection.call(void 0, results);
  }
  return rewindFeature(geojson, reverse);
}
function rewindFeature(geojson, reverse) {
  const type = geojson.type === "Feature" ? geojson.geometry.type : geojson.type;
  switch (type) {
    case "GeometryCollection":
      _meta.geomEach.call(void 0, geojson, function(geometry) {
        rewindFeature(geometry, reverse);
      });
      return geojson;
    case "LineString":
      rewindLineString(_invariant.getCoords.call(void 0, geojson), reverse);
      return geojson;
    case "Polygon":
      rewindPolygon(_invariant.getCoords.call(void 0, geojson), reverse);
      return geojson;
    case "MultiLineString":
      _invariant.getCoords.call(void 0, geojson).forEach(function(lineCoords) {
        rewindLineString(lineCoords, reverse);
      });
      return geojson;
    case "MultiPolygon":
      _invariant.getCoords.call(void 0, geojson).forEach(function(lineCoords) {
        rewindPolygon(lineCoords, reverse);
      });
      return geojson;
    case "Point":
    case "MultiPoint":
      return geojson;
  }
}
function rewindLineString(coords, reverse) {
  if (_booleanclockwise.booleanClockwise.call(void 0, coords) === reverse) coords.reverse();
}
function rewindPolygon(coords, reverse) {
  if (_booleanclockwise.booleanClockwise.call(void 0, coords[0]) !== reverse) {
    coords[0].reverse();
  }
  for (let i = 1; i < coords.length; i++) {
    if (_booleanclockwise.booleanClockwise.call(void 0, coords[i]) === reverse) {
      coords[i].reverse();
    }
  }
}
var turf_rewind_default = rewind;



exports.default = turf_rewind_default; exports.rewind = rewind;
//# sourceMappingURL=index.cjs.map