"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _helpers = require('@turf/helpers');
var _invariant = require('@turf/invariant');
function polygonToLine(poly, options = {}) {
  const geom = _invariant.getGeom.call(void 0, poly);
  if (!options.properties && poly.type === "Feature") {
    options.properties = poly.properties;
  }
  switch (geom.type) {
    case "Polygon":
      return singlePolygonToLine(geom, options);
    case "MultiPolygon":
      return multiPolygonToLine(geom, options);
    default:
      throw new Error("invalid poly");
  }
}
function singlePolygonToLine(poly, options = {}) {
  const geom = _invariant.getGeom.call(void 0, poly);
  const coords = geom.coordinates;
  const properties = options.properties ? options.properties : poly.type === "Feature" ? poly.properties : {};
  return coordsToLine(coords, properties);
}
function multiPolygonToLine(multiPoly, options = {}) {
  const geom = _invariant.getGeom.call(void 0, multiPoly);
  const coords = geom.coordinates;
  const properties = options.properties ? options.properties : multiPoly.type === "Feature" ? multiPoly.properties : {};
  const lines = [];
  coords.forEach((coord) => {
    lines.push(coordsToLine(coord, properties));
  });
  return _helpers.featureCollection.call(void 0, lines);
}
function coordsToLine(coords, properties) {
  if (coords.length > 1) {
    return _helpers.multiLineString.call(void 0, coords, properties);
  }
  return _helpers.lineString.call(void 0, coords[0], properties);
}
var turf_polygon_to_line_default = polygonToLine;






exports.coordsToLine = coordsToLine; exports.default = turf_polygon_to_line_default; exports.multiPolygonToLine = multiPolygonToLine; exports.polygonToLine = polygonToLine; exports.singlePolygonToLine = singlePolygonToLine;
//# sourceMappingURL=index.cjs.map