// index.ts
import { booleanPointInPolygon as pointInPolygon } from "@turf/boolean-point-in-polygon";
import { featureCollection, multiPoint } from "@turf/helpers";
import { geomEach, featureEach, coordEach } from "@turf/meta";
function pointsWithinPolygon(points, polygons) {
  const results = [];
  featureEach(points, function(point) {
    let contained = false;
    if (point.geometry.type === "Point") {
      geomEach(polygons, function(polygon) {
        if (pointInPolygon(point, polygon)) {
          contained = true;
        }
      });
      if (contained) {
        results.push(point);
      }
    } else if (point.geometry.type === "MultiPoint") {
      var pointsWithin = [];
      geomEach(polygons, function(polygon) {
        coordEach(point, function(pointCoord) {
          if (pointInPolygon(pointCoord, polygon)) {
            contained = true;
            pointsWithin.push(pointCoord);
          }
        });
      });
      if (contained) {
        results.push(
          multiPoint(pointsWithin, point.properties)
        );
      }
    } else {
      throw new Error("Input geometry must be a Point or MultiPoint");
    }
  });
  return featureCollection(results);
}
var turf_points_within_polygon_default = pointsWithinPolygon;
export {
  turf_points_within_polygon_default as default,
  pointsWithinPolygon
};
//# sourceMappingURL=index.js.map