import { GeoJsonProperties, BBox, Feature, Polygon, MultiPolygon, FeatureCollection, Point } from 'geojson';
import { Units } from '@turf/helpers';

/**
 * Creates a grid of points
 *
 * @function
 * @param {BBox} bbox extent of grid in [minX, minY, maxX, maxY] order
 * @param {number} cellSide the distance between points
 * @param {Object} [options={}] Optional parameters
 * @param {Units} [options.units='kilometers'] the units of the cellSide value.  Supports all valid Turf {@link https://github.com/Turfjs/turf/blob/master/packages/turf-helpers/README_UNITS.md Units}
 * @param {Feature<Polygon|MultiPolygon>} [options.mask] if passed a Polygon or MultiPolygon, the grid Points will be created only inside it
 * @param {Object} [options.properties={}] passed to each point of the grid
 * @returns {FeatureCollection<Point>} grid of points
 * @example
 * var extent = [-70.823364, -33.553984, -70.473175, -33.302986];
 * var cellSide = 3;
 * var options = {units: 'miles'};
 *
 * var grid = turf.pointGrid(extent, cellSide, options);
 *
 * //addToMap
 * var addToMap = [grid];
 */
declare function pointGrid<P extends GeoJsonProperties = GeoJsonProperties>(bbox: BBox, cellSide: number, options?: {
    units?: Units;
    mask?: Feature<Polygon | MultiPolygon>;
    properties?: P;
}): FeatureCollection<Point, P>;

export { pointGrid as default, pointGrid };
