# @turf/nearest-neighbor-analysis

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## NearestNeighborStatistics

Nearest neighbour statistics.

Type: [object][1]

### Properties

*   `arealUnits` **[string][2]**&#x20;
*   `observedMeanDistance` **[number][3]**&#x20;
*   `expectedMeanDistance` **[number][3]**&#x20;
*   `numberOfPoints` **[number][3]**&#x20;
*   `zScore` **[number][3]**&#x20;

## NearestNeighborStudyArea

Nearest neighbour study area polygon feature.

Type: [object][1]

### Properties

*   `properties` **[GeoJsonProperties][4]**&#x20;

    *   `properties.nearestNeighborAnalysis` **[NearestNeighborStatistics][5]**&#x20;

## nearestNeighborAnalysis

Nearest Neighbor Analysis calculates an index based the average distances
between points in the dataset, thereby providing inference as to whether the
data is clustered, dispersed, or randomly distributed within the study area.

It returns a [Feature][4]<[Polygon][6]> of the study area, with the results of
the analysis attached as part of of the `nearestNeighborAnalysis` property
of the study area's `properties`. The attached
[*z*-score][7] indicates how many
standard deviations above or below the expected mean distance the data's
observed mean distance is. The more negative, the more clustered. The more
positive, the more evenly dispersed. A *z*-score between -2 and 2 indicates
a seemingly random distribution. That is, within *p* of less than 0.05, the
distribution appears statistically significantly neither clustered nor
dispersed.

**Remarks**

*   Though the analysis will work on any [FeatureCollection][8] type, it
    works best with [Point][9] collections.

*   This analysis is *very* sensitive to the study area provided.
    If no [Feature][4]<[Polygon][6]> is passed as the study area, the function draws a box
    around the data, which may distort the findings. This analysis works best
    with a bounded area of interest within with the data is either clustered,
    dispersed, or randomly distributed. For example, a city's subway stops may
    look extremely clustered if the study area is an entire state. On the other
    hand, they may look rather evenly dispersed if the study area is limited to
    the city's downtown.

**Bibliography**

Philip J. Clark and Francis C. Evans, “Distance to Nearest Neighbor as a
Measure of Spatial Relationships in Populations,” *Ecology* 35, no. 4
(1954): 445–453, doi:[10.2307/1931034][10].

### Parameters

*   `dataset` **[FeatureCollection][8]\<any>** FeatureCollection (pref. of points) to study
*   `options` **[Object][1]** Optional parameters (optional, default `{}`)

    *   `options.studyArea` **[Feature][4]<[Polygon][6]>?** polygon representing the study area
    *   `options.properties` **[GeoJsonProperties][4]** properties (optional, default `{}`)

### Examples

```javascript
var bbox = [-65, 40, -63, 42];
var dataset = turf.randomPoint(100, { bbox: bbox });
var nearestNeighborStudyArea = turf.nearestNeighborAnalysis(dataset);

//addToMap
var addToMap = [dataset, nearestNeighborStudyArea];
```

Returns **[NearestNeighborStudyArea][11]** A polygon of the study area or an approximation of one.

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[4]: https://tools.ietf.org/html/rfc7946#section-3.2

[5]: #nearestneighborstatistics

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[7]: https://en.wikipedia.org/wiki/Standard_score

[8]: https://tools.ietf.org/html/rfc7946#section-3.3

[9]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[10]: http://doi.org/10.2307/1931034

[11]: #nearestneighborstudyarea

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/nearest-neighbor-analysis
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
