# @turf/midpoint

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## midpoint

Takes two points and returns a point midway between them. The midpoint is
calculated geodesically, meaning the curvature of the earth is taken into
account.

### Parameters

*   `point1` **[Coord][1]** first point
*   `point2` **[Coord][1]** second point

### Examples

```javascript
const point1 = turf.point([144.834823, -37.771257]);
const point2 = turf.point([145.14244, -37.830937]);

const midpoint = turf.midpoint(point1, point2);

//addToMap
const addToMap = [point1, point2, midpoint];
midpoint.properties['marker-color'] = '#f00';
```

Returns **[Feature][2]<[Point][3]>** a point midway between `pt1` and `pt2`

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[2]: https://tools.ietf.org/html/rfc7946#section-3.2

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.2

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/midpoint
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
