// index.ts
import { bbox as turfBBox } from "@turf/bbox";
import { getCoords, getGeom } from "@turf/invariant";
import { polygon, multiPolygon, lineString } from "@turf/helpers";
import { clone } from "@turf/clone";
function lineToPolygon(lines, options = {}) {
  var _a, _b, _c;
  var properties = options.properties;
  var autoComplete = (_a = options.autoComplete) != null ? _a : true;
  var orderCoords = (_b = options.orderCoords) != null ? _b : true;
  var mutate = (_c = options.mutate) != null ? _c : false;
  if (!mutate) {
    lines = clone(lines);
  }
  switch (lines.type) {
    case "FeatureCollection":
      var coords = [];
      lines.features.forEach(function(line) {
        coords.push(
          getCoords(lineStringToPolygon(line, {}, autoComplete, orderCoords))
        );
      });
      return multiPolygon(coords, properties);
    default:
      return lineStringToPolygon(lines, properties, autoComplete, orderCoords);
  }
}
function lineStringToPolygon(line, properties, autoComplete, orderCoords) {
  properties = properties ? properties : line.type === "Feature" ? line.properties : {};
  var geom = getGeom(line);
  var coords = geom.coordinates;
  var type = geom.type;
  if (!coords.length) throw new Error("line must contain coordinates");
  switch (type) {
    case "LineString":
      if (autoComplete) coords = autoCompleteCoords(coords);
      return polygon([coords], properties);
    case "MultiLineString":
      var multiCoords = [];
      var largestArea = 0;
      coords.forEach(function(coord) {
        if (autoComplete) coord = autoCompleteCoords(coord);
        if (orderCoords) {
          var area = calculateArea(turfBBox(lineString(coord)));
          if (area > largestArea) {
            multiCoords.unshift(coord);
            largestArea = area;
          } else multiCoords.push(coord);
        } else {
          multiCoords.push(coord);
        }
      });
      return polygon(multiCoords, properties);
    default:
      throw new Error("geometry type " + type + " is not supported");
  }
}
function autoCompleteCoords(coords) {
  var first = coords[0];
  var x1 = first[0];
  var y1 = first[1];
  var last = coords[coords.length - 1];
  var x2 = last[0];
  var y2 = last[1];
  if (x1 !== x2 || y1 !== y2) {
    coords.push(first);
  }
  return coords;
}
function calculateArea(bbox) {
  var west = bbox[0];
  var south = bbox[1];
  var east = bbox[2];
  var north = bbox[3];
  return Math.abs(west - east) * Math.abs(south - north);
}
var turf_line_to_polygon_default = lineToPolygon;
export {
  turf_line_to_polygon_default as default,
  lineToPolygon
};
//# sourceMappingURL=index.js.map