// index.js
import { bearing } from "@turf/bearing";
import { distance } from "@turf/distance";
import { destination } from "@turf/destination";
import { lineString, isObject } from "@turf/helpers";
function lineSliceAlong(line, startDist, stopDist, options) {
  options = options || {};
  if (!isObject(options)) throw new Error("options is invalid");
  var coords;
  var slice = [];
  if (line.type === "Feature") coords = line.geometry.coordinates;
  else if (line.type === "LineString") coords = line.coordinates;
  else throw new Error("input must be a LineString Feature or Geometry");
  var origCoordsLength = coords.length;
  var travelled = 0;
  var overshot, direction, interpolated;
  for (var i = 0; i < coords.length; i++) {
    if (startDist >= travelled && i === coords.length - 1) break;
    else if (travelled > startDist && slice.length === 0) {
      overshot = startDist - travelled;
      if (!overshot) {
        slice.push(coords[i]);
        return lineString(slice);
      }
      direction = bearing(coords[i], coords[i - 1]) - 180;
      interpolated = destination(coords[i], overshot, direction, options);
      slice.push(interpolated.geometry.coordinates);
    }
    if (travelled >= stopDist) {
      overshot = stopDist - travelled;
      if (!overshot) {
        slice.push(coords[i]);
        return lineString(slice);
      }
      direction = bearing(coords[i], coords[i - 1]) - 180;
      interpolated = destination(coords[i], overshot, direction, options);
      slice.push(interpolated.geometry.coordinates);
      return lineString(slice);
    }
    if (travelled >= startDist) {
      slice.push(coords[i]);
    }
    if (i === coords.length - 1) {
      return lineString(slice);
    }
    travelled += distance(coords[i], coords[i + 1], options);
  }
  if (travelled < startDist && coords.length === origCoordsLength)
    throw new Error("Start position is beyond line");
  var last = coords[coords.length - 1];
  return lineString([last, last]);
}
var turf_line_slice_along_default = lineSliceAlong;
export {
  turf_line_slice_along_default as default,
  lineSliceAlong
};
//# sourceMappingURL=index.js.map