/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import {
  Entity,
  Column,
  BaseEntity,
  ManyToOne,
  PrimaryGeneratedColumn,
} from "typeorm";
import TherapistEntity from "./TherapistEntity";

@Entity({ name: "timeslots" })
export default class TimeslotEntity extends BaseEntity {
  //TODO: the type should be inferred by typeorm for all attributes
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: "text" })
  day_of_week: string;

  @Column({ type: "int" })
  start_hour: number;

  @Column({ type: "int" })
  start_minute: number;

  @Column({ type: "int" })
  end_hour: number;

  @Column({ type: "int" })
  end_minute: number;

  @ManyToOne(() => TherapistEntity, (therapist) => therapist.timeslots, {
    orphanedRowAction: "delete",
  })
  therapist: TherapistEntity;
}
