/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import { DefaultTheme, Theme } from "@react-navigation/native";
import { MD3LightTheme, MD3DarkTheme, MD3Theme } from "react-native-paper";

const TFLightTheme: MD3Theme = {
  ...MD3LightTheme,
  colors: {
    primary: "rgb(0, 98, 157)",
    onPrimary: "rgb(255, 255, 255)",
    primaryContainer: "rgb(207, 229, 255)",
    onPrimaryContainer: "rgb(0, 29, 51)",
    secondary: "rgb(140, 51, 179)",
    onSecondary: "rgb(255, 255, 255)",
    secondaryContainer: "rgb(248, 216, 255)",
    onSecondaryContainer: "rgb(50, 0, 71)",
    tertiary: "rgb(0, 105, 113)",
    onTertiary: "rgb(255, 255, 255)",
    tertiaryContainer: "rgb(137, 242, 255)",
    onTertiaryContainer: "rgb(0, 31, 35)",
    error: "rgb(186, 26, 26)",
    onError: "rgb(255, 255, 255)",
    errorContainer: "rgb(255, 218, 214)",
    onErrorContainer: "rgb(65, 0, 2)",
    background: "rgb(252, 252, 255)",
    onBackground: "rgb(26, 28, 30)",
    surface: "rgb(252, 252, 255)",
    onSurface: "rgb(26, 28, 30)",
    surfaceVariant: "rgb(222, 227, 235)",
    onSurfaceVariant: "rgb(66, 71, 78)",
    outline: "rgb(114, 119, 127)",
    outlineVariant: "rgb(194, 199, 207)",
    shadow: "rgb(0, 0, 0)",
    scrim: "rgb(0, 0, 0)",
    inverseSurface: "rgb(47, 48, 51)",
    inverseOnSurface: "rgb(241, 240, 244)",
    inversePrimary: "rgb(153, 203, 255)",
    elevation: {
      level0: "transparent",
      level1: "rgb(239, 244, 250)",
      level2: "rgb(232, 240, 247)",
      level3: "rgb(224, 235, 244)",
      level4: "rgb(222, 234, 243)",
      level5: "rgb(217, 230, 241)",
    },
    surfaceDisabled: "rgba(26, 28, 30, 0.12)",
    onSurfaceDisabled: "rgba(26, 28, 30, 0.38)",
    backdrop: "rgba(44, 49, 55, 0.4)",
  },
};

const TFDarkTheme: MD3Theme = {
  ...MD3DarkTheme,
  colors: {
    primary: "rgb(153, 203, 255)",
    onPrimary: "rgb(0, 51, 84)",
    primaryContainer: "rgb(0, 74, 120)",
    onPrimaryContainer: "rgb(207, 229, 255)",
    secondary: "rgb(235, 178, 255)",
    onSecondary: "rgb(82, 0, 113)",
    secondaryContainer: "rgb(114, 17, 153)",
    onSecondaryContainer: "rgb(248, 216, 255)",
    tertiary: "rgb(77, 216, 231)",
    onTertiary: "rgb(0, 54, 59)",
    tertiaryContainer: "rgb(0, 79, 86)",
    onTertiaryContainer: "rgb(137, 242, 255)",
    error: "rgb(255, 180, 171)",
    onError: "rgb(105, 0, 5)",
    errorContainer: "rgb(147, 0, 10)",
    onErrorContainer: "rgb(255, 180, 171)",
    background: "rgb(26, 28, 30)",
    onBackground: "rgb(226, 226, 229)",
    surface: "rgb(26, 28, 30)",
    onSurface: "rgb(226, 226, 229)",
    surfaceVariant: "rgb(66, 71, 78)",
    onSurfaceVariant: "rgb(194, 199, 207)",
    outline: "rgb(140, 145, 153)",
    outlineVariant: "rgb(66, 71, 78)",
    shadow: "rgb(0, 0, 0)",
    scrim: "rgb(0, 0, 0)",
    inverseSurface: "rgb(226, 226, 229)",
    inverseOnSurface: "rgb(47, 48, 51)",
    inversePrimary: "rgb(0, 98, 157)",
    elevation: {
      level0: "transparent",
      level1: "rgb(32, 37, 41)",
      level2: "rgb(36, 42, 48)",
      level3: "rgb(40, 47, 55)",
      level4: "rgb(41, 49, 57)",
      level5: "rgb(44, 53, 62)",
    },
    surfaceDisabled: "rgba(226, 226, 229, 0.12)",
    onSurfaceDisabled: "rgba(226, 226, 229, 0.38)",
    backdrop: "rgba(44, 49, 55, 0.4)",
  },
};

const NavThemeDark: Theme = {
  dark: true,
  colors: {
    ...TFDarkTheme.colors,
    card: TFDarkTheme.colors.elevation.level5,
    text: TFDarkTheme.colors.onBackground,
    border: TFDarkTheme.colors.background,
    notification: TFDarkTheme.colors.secondary,
  },
  fonts: DefaultTheme.fonts,
};

const NavThemeLight: Theme = {
  dark: false,
  colors: {
    ...TFLightTheme.colors,
    card: TFLightTheme.colors.elevation.level5,
    text: TFLightTheme.colors.onBackground,
    border: TFLightTheme.colors.background,
    notification: TFLightTheme.colors.secondary,
  },
  fonts: DefaultTheme.fonts,
};

export { TFLightTheme, TFDarkTheme, NavThemeDark, NavThemeLight };
