/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import DateTimePicker from "@react-native-community/datetimepicker";
import { Platform, View } from "react-native";
import React, { useState } from "react";
import { timeToString } from "@/utils/misc";
import { useTheme, Button } from "react-native-paper";

export interface TimePickerProps {
  selectedHour: number;
  selectedMinute: number;
  setSelectedTime: (hour: number, minute: number) => void;
}

export default function TimePicker({
  selectedHour,
  selectedMinute,
  setSelectedTime,
}: TimePickerProps) {
  const theme = useTheme();
  const [showTimePicker, setShowTimePicker] = useState(false);

  const handleTimeChange = (_, selectedDate: Date) => {
    setShowTimePicker(false);
    setSelectedTime(selectedDate.getHours(), selectedDate.getMinutes());
  };

  return (
    <View>
      {!(showTimePicker || Platform.OS == "ios") && (
        <Button
          onPress={() => {
            setShowTimePicker(true);
          }}
          buttonColor={theme.colors.primary}
          textColor={theme.colors.onPrimary}
          style={{ margin: 2 }}
        >
          {timeToString(selectedHour, selectedMinute)}
        </Button>
      )}
      {(showTimePicker || Platform.OS == "ios") && (
        <DateTimePicker
          value={(() => {
            const d = new Date();
            d.setHours(selectedHour, selectedMinute);
            return d;
          })()}
          mode="time"
          is24Hour={true}
          onChange={handleTimeChange}
        />
      )}
    </View>
  );
}
