/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * component used in call view to divide timeslots
 */

import { StyleSheet, View } from "react-native";
import { Text, useTheme } from "react-native-paper";

export interface TimeDividerProps {
  title: string;
}

export default function TimeDivider(props: TimeDividerProps) {
  const theme = useTheme();

  return (
    <>
      <View
        style={{
          ...styles.container,
          backgroundColor: theme.colors.elevation.level4,
        }}
      >
        <Text style={styles.title}>{props.title}</Text>
      </View>
    </>
  );
}

const styles = StyleSheet.create({
  container: {
    height: 25,
    paddingStart: 5,
    width: "100%",
    justifyContent: "center",
  },
  title: {
    fontSize: 16,
  },
});
