/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import { useEffect } from "react";
import notifee, {
  AuthorizationStatus,
  NotificationSettings,
} from "@notifee/react-native";
import { Button, ButtonProps } from "react-native-paper";

export type NotificationPermissionButtonProps = ButtonProps & {
  notificationPermission: boolean;
  setNotificationPermission: (value: boolean) => void;
};

export default function NotificationPermissionButton({
  notificationPermission,
  setNotificationPermission,
  ...rest
}: NotificationPermissionButtonProps) {
  const callbackSetter = (s: NotificationSettings) => {
    setNotificationPermission(
      s.authorizationStatus > AuthorizationStatus.DENIED,
    );
  };

  useEffect(() => {
    notifee.getNotificationSettings().then(callbackSetter);
  }, []);

  return (
    <Button
      onPress={() => {
        notifee.requestPermission().then(callbackSetter);
      }}
      {...rest}
    >
      {notificationPermission
        ? "Notification Berechtigung erteilt"
        : "Notification Berechtigung nicht erteilt"}{" "}
    </Button>
  );
}
