/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import { TextInput, TextInputProps, useTheme } from "react-native-paper";
import { StyleSheet, View } from "react-native";

export type EditFieldProps = TextInputProps & {
  icon?: string;
  title?: string;
};

export default function EditField({ icon, title, ...rest }: EditFieldProps) {
  const theme = useTheme();
  return (
    <View
      style={[
        {
          backgroundColor: theme.colors.background,
        },
        styles.row,
      ]}
    >
      <TextInput
        label={title}
        mode="flat"
        left={!!icon && <TextInput.Icon icon={icon} />}
        style={{
          width: "90%",
          marginBottom: 5,
          backgroundColor: theme.colors.elevation.level3,
          borderRadius: 5,
        }}
        underlineColor={theme.colors.background}
        {...rest}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  row: {
    flexDirection: "row",
    alignItems: "center",
    flex: 1,
  },
  inputIcon: {
    marginLeft: 5,
    marginRight: 15,
  },
  label: {
    flexGrow: 1,
    marginLeft: 10,
  },
});
