/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import { createContext, useEffect, useState } from "react";
import TherapistsDS from "@/data/DataSource";
import { Text } from "react-native-paper";
import { DataSource } from "typeorm";

export const DataContext = createContext<DataSource>();

export const DataProvider = ({ children }) => {
  const [loadedDS, setLoadedDS] = useState<DataSource | null>(null);

  useEffect(() => {
    TherapistsDS.initialize().then(() => {
      setLoadedDS(TherapistsDS);
    });
  }, []);

  if (loadedDS) {
    return (
      <DataContext.Provider value={loadedDS}>{children}</DataContext.Provider>
    );
  } else {
    return <Text>Datenbank wird geladen...</Text>;
  }
};
