/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import { useEffect } from "react";
import notifee, { AndroidNotificationSetting } from "@notifee/react-native";
import { Button, ButtonProps } from "react-native-paper";

export type AlarmPermissionButtonProps = ButtonProps & {
  alarmPermission: boolean;
  setAlarmPermission: (value: boolean) => void;
};

export default function AlarmPermissionButton({
  alarmPermission,
  setAlarmPermission,
  ...rest
}: AlarmPermissionButtonProps) {
  const reload = () => {
    notifee.getNotificationSettings().then((s) => {
      setAlarmPermission(s.android.alarm == AndroidNotificationSetting.ENABLED);
    });
  };

  useEffect(() => {
    reload();
  }, []);

  return (
    <Button
      onPress={() => {
        notifee.openAlarmPermissionSettings().then(reload);
      }}
      {...rest}
    >
      {alarmPermission
        ? "Alarm Berechtigung erteilt"
        : "Alarm Berechtigung nicht erteilt"}
    </Button>
  );
}
