/**
 * Copyright (C) 2025 Finn Landweber and olell
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import Ionicons from "@expo/vector-icons/Ionicons";
import { useTheme } from "react-native-paper";

import { Tabs } from "expo-router";

export default function TabLayout() {
  const theme = useTheme();

  return (
    <Tabs
      screenOptions={{
        tabBarActiveTintColor: theme.colors.onBackground,
        tabBarStyle: {
          backgroundColor: theme.colors.background,
        },
      }}
    >
      <Tabs.Screen
        name="index"
        options={{
          headerShadowVisible: false,
          headerStyle: {
            backgroundColor: theme.colors.background,
            borderBottomWidth: 0,
          },
          title: "Anrufen",
          tabBarIcon: ({ color }) => (
            <Ionicons size={28} name="call" color={color} />
          ),
        }}
      />
      <Tabs.Screen
        name="protocol"
        options={{
          headerShadowVisible: false,
          headerStyle: { backgroundColor: theme.colors.background },
          title: "Protokoll",
          tabBarIcon: ({ color }) => (
            <Ionicons size={28} name="file-tray-full" color={color} />
          ),
        }}
      />
      <Tabs.Screen
        name="list"
        options={{
          headerShadowVisible: false,
          headerStyle: { backgroundColor: theme.colors.background },
          title: "Deine Liste",
          tabBarIcon: ({ color }) => (
            <Ionicons size={28} name="list" color={color} />
          ),
        }}
      />
    </Tabs>
  );
}
