"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _meta = require('@turf/meta');
var _helpers = require('@turf/helpers');
function truncate(geojson, options) {
  options = options != null ? options : {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  var precision = options.precision;
  var coordinates = options.coordinates;
  var mutate = options.mutate;
  precision = precision === void 0 || precision === null || isNaN(precision) ? 6 : precision;
  coordinates = coordinates === void 0 || coordinates === null || isNaN(coordinates) ? 3 : coordinates;
  if (!geojson) throw new Error("<geojson> is required");
  if (typeof precision !== "number")
    throw new Error("<precision> must be a number");
  if (typeof coordinates !== "number")
    throw new Error("<coordinates> must be a number");
  if (mutate === false || mutate === void 0)
    geojson = JSON.parse(JSON.stringify(geojson));
  var factor = Math.pow(10, precision);
  _meta.coordEach.call(void 0, geojson, function(coords) {
    truncateCoords(coords, factor, coordinates);
  });
  return geojson;
}
function truncateCoords(coords, factor, coordinates) {
  if (coords.length > coordinates) coords.splice(coordinates, coords.length);
  for (var i = 0; i < coords.length; i++) {
    coords[i] = Math.round(coords[i] * factor) / factor;
  }
  return coords;
}
var turf_truncate_default = truncate;



exports.default = turf_truncate_default; exports.truncate = truncate;
//# sourceMappingURL=index.cjs.map