"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _helpers = require('@turf/helpers');
var _invariant = require('@turf/invariant');
function rhumbBearing(start, end, options = {}) {
  let bear360;
  if (options.final) {
    bear360 = calculateRhumbBearing(_invariant.getCoord.call(void 0, end), _invariant.getCoord.call(void 0, start));
  } else {
    bear360 = calculateRhumbBearing(_invariant.getCoord.call(void 0, start), _invariant.getCoord.call(void 0, end));
  }
  const bear180 = bear360 > 180 ? -(360 - bear360) : bear360;
  return bear180;
}
function calculateRhumbBearing(from, to) {
  const phi1 = _helpers.degreesToRadians.call(void 0, from[1]);
  const phi2 = _helpers.degreesToRadians.call(void 0, to[1]);
  let deltaLambda = _helpers.degreesToRadians.call(void 0, to[0] - from[0]);
  if (deltaLambda > Math.PI) {
    deltaLambda -= 2 * Math.PI;
  }
  if (deltaLambda < -Math.PI) {
    deltaLambda += 2 * Math.PI;
  }
  const deltaPsi = Math.log(
    Math.tan(phi2 / 2 + Math.PI / 4) / Math.tan(phi1 / 2 + Math.PI / 4)
  );
  const theta = Math.atan2(deltaLambda, deltaPsi);
  return (_helpers.radiansToDegrees.call(void 0, theta) + 360) % 360;
}
var turf_rhumb_bearing_default = rhumbBearing;



exports.default = turf_rhumb_bearing_default; exports.rhumbBearing = rhumbBearing;
//# sourceMappingURL=index.cjs.map