# @turf/nearest-point

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## nearestPoint

Takes a reference [point][1] and a FeatureCollection of Features
with Point geometries and returns the
point from the FeatureCollection closest to the reference. This calculation
is geodesic.

### Parameters

*   `targetPoint` **[Coord][2]** the reference point
*   `points` **[FeatureCollection][3]<[Point][1]>** against input point set
*   `options` **[Object][4]** Optional parameters (optional, default `{}`)

    *   `options.units` **[string][5]** the units of the numeric result (optional, default `'kilometers'`)

### Examples

```javascript
var targetPoint = turf.point([28.965797, 41.010086], {"marker-color": "#0F0"});
var points = turf.featureCollection([
    turf.point([28.973865, 41.011122]),
    turf.point([28.948459, 41.024204]),
    turf.point([28.938674, 41.013324])
]);

var nearest = turf.nearestPoint(targetPoint, points);

//addToMap
var addToMap = [targetPoint, points, nearest];
nearest.properties['marker-color'] = '#F00';
```

Returns **[Feature][6]<[Point][1]>** the closest point in the set to the reference point

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[3]: https://tools.ietf.org/html/rfc7946#section-3.3

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[6]: https://tools.ietf.org/html/rfc7946#section-3.2

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/nearest-point
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
