// eslint-disable-next-line @typescript-eslint/no-require-imports,no-undef
const { withAppBuildGradle } = require("expo/config-plugins");

// eslint-disable-next-line no-undef
module.exports = function withCustomAppBuildGradle(config) {
  // eslint-disable-next-line  @typescript-eslint/no-unsafe-argument
  return withAppBuildGradle(config, (config) => {
    const releaseSigningConfig = `
        release {
            if (
                System.env.UPLOAD_STORE_FILE != null && 
                System.env.UPLOAD_STORE_PASSWORD != null && 
                System.env.UPLOAD_KEY_ALIAS != null &&
                System.env.UPLOAD_KEY_PASSWORD != null
            ) {
            	  storeFile file(System.env.UPLOAD_STORE_FILE)
            	  storePassword System.env.UPLOAD_STORE_PASSWORD
            	  keyAlias System.env.UPLOAD_KEY_ALIAS
            	  keyPassword System.env.UPLOAD_KEY_PASSWORD
            } else {
                storeFile file('debug.keystore')
                storePassword 'android'
                keyAlias 'androiddebugkey'
                keyPassword 'android'
            }
        }
`;

    config.modResults.contents = config.modResults.contents.replace(
      /signingConfigs\s*{/,
      (match) => match + releaseSigningConfig,
    );

    config.modResults.contents = config.modResults.contents.replace(
      `        release {
            // Caution! In production, you need to generate your own keystore file.
            // see https://reactnative.dev/docs/signed-apk-android.
            signingConfig signingConfigs.debug`,
      `        release {
            signingConfig signingConfigs.release`,
    );

    return config;
  });
};
