/*
 * Copyright 2019 Mike Penz
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.tasks.icons

import com.mikepenz.iconics.typeface.IIcon
import com.mikepenz.iconics.typeface.ITypeface
import java.util.LinkedList

@Suppress("EnumEntryName")
object OutlinedGoogleMaterial : ITypeface {

    override val fontRes: Int
        get() = R.font.google_material_font_40811b1

    override val characters: Map<String, Char> by lazy {
        Icon.values().associate { it.name to it.character }
    }
    
    override val mappingPrefix: String
        get() = "gmo"

    override val fontName: String
        get() = "Google Material"

    override val version: String
        get() = "1"

    override val iconCount: Int
        get() = characters.size

    override val icons: List<String>
        get() = characters.keys.toCollection(LinkedList())

    override val author: String
        get() = "Google"

    override val url: String
        get() = "https://github.com/google/material-design-icons/tree/master/symbols/web"

    override val description: String
        get() = "Google Material Icons"

    override val license: String
        get() = "Apache 2.0"

    override val licenseUrl: String
        get() = "https://github.com/google/material-design-icons/blob/master/LICENSE"

    override fun getIcon(key: String): IIcon = try {
		Icon.valueOf(key)
	} catch (e: IllegalArgumentException) {
		OutlinedGoogleMaterial2.getIcon(key)
	}

    enum class Icon constructor(override val character: Char) : IIcon {
        gmo_10k('\ufe70'),
		gmo_10mp('\ufe6f'),
		gmo_11mp('\ufe6e'),
		gmo_123('\uf101'),
		gmo_12mp('\ufe6d'),
		gmo_13mp('\ufe6c'),
		gmo_14mp('\ufe6b'),
		gmo_15mp('\ufe6a'),
		gmo_16mp('\ufe69'),
		gmo_17mp('\ufe68'),
		gmo_18_up_rating('\ufe67'),
		gmo_18mp('\ufe66'),
		gmo_19mp('\ufe65'),
		gmo_1k('\ufe64'),
		gmo_1k_plus('\ufe63'),
		gmo_1x_mobiledata('\ufe62'),
		gmo_1x_mobiledata_badge('\ufe61'),
		gmo_20mp('\ufe60'),
		gmo_21mp('\ufe5f'),
		gmo_22mp('\ufe5e'),
		gmo_23mp('\ufe5d'),
		gmo_24mp('\ufe5c'),
		gmo_2d('\ufe5b'),
		gmo_2k('\ufe5a'),
		gmo_2k_plus('\ufe59'),
		gmo_2mp('\ufe58'),
		gmo_30fps('\ufe57'),
		gmo_30fps_select('\ufe56'),
		gmo_360('\uf102'),
		gmo_3d_rotation('\ufe55'),
		gmo_3g_mobiledata('\ufe54'),
		gmo_3g_mobiledata_badge('\ufe53'),
		gmo_3k('\ufe52'),
		gmo_3k_plus('\ufe51'),
		gmo_3mp('\ufe50'),
		gmo_3p('\ufe4f'),
		gmo_4g_mobiledata('\ufe4e'),
		gmo_4g_mobiledata_badge('\ufe4d'),
		gmo_4g_plus_mobiledata('\ufe4c'),
		gmo_4k('\ufe4b'),
		gmo_4k_plus('\ufe4a'),
		gmo_4mp('\ufe49'),
		gmo_50mp('\ufe48'),
		gmo_5g('\ufe47'),
		gmo_5g_mobiledata_badge('\ufe46'),
		gmo_5k('\ufe45'),
		gmo_5k_plus('\ufe44'),
		gmo_5mp('\ufe43'),
		gmo_60fps('\ufe42'),
		gmo_60fps_select('\ufe41'),
		gmo_6_ft_apart('\ufe40'),
		gmo_6k('\ufe3f'),
		gmo_6k_plus('\ufe3e'),
		gmo_6mp('\ufe3d'),
		gmo_7k('\ufe3c'),
		gmo_7k_plus('\ufe3b'),
		gmo_7mp('\ufe3a'),
		gmo_8k('\ufe39'),
		gmo_8k_plus('\ufe38'),
		gmo_8mp('\ufe37'),
		gmo_9k('\ufe36'),
		gmo_9k_plus('\ufe35'),
		gmo_9mp('\ufe34'),
		gmo_abc('\ufe33'),
		gmo_ac_unit('\ufe32'),
		gmo_accessibility('\ufe31'),
		gmo_accessibility_new('\ufe30'),
		gmo_accessible('\ufe2f'),
		gmo_accessible_forward('\ufe2e'),
		gmo_account_balance('\ufe2d'),
		gmo_account_balance_wallet('\ufe2c'),
		gmo_account_box('\ufe2b'),
		gmo_account_child('\ufe2a'),
		gmo_account_child_invert('\ufe29'),
		gmo_account_circle('\ufe28'),
		gmo_account_circle_off('\ufe27'),
		gmo_account_tree('\ufe26'),
		gmo_action_key('\ufe25'),
		gmo_activity_zone('\ufe24'),
		gmo_acute('\ufe23'),
		gmo_ad('\ufe22'),
		gmo_ad_group('\ufe21'),
		gmo_ad_group_off('\ufe20'),
		gmo_ad_off('\ufe1f'),
		gmo_ad_units('\ufe1e'),
		gmo_adaptive_audio_mic('\ufe1d'),
		gmo_adaptive_audio_mic_off('\ufe1c'),
		gmo_adb('\ufe1b'),
		gmo_add('\ufe1a'),
		gmo_add_a_photo('\ufe19'),
		gmo_add_ad('\ufe18'),
		gmo_add_alert('\ufe17'),
		gmo_add_box('\ufe16'),
		gmo_add_business('\ufe15'),
		gmo_add_call('\ufe14'),
		gmo_add_card('\ufe13'),
		gmo_add_chart('\ufe12'),
		gmo_add_circle('\ufe11'),
		gmo_add_comment('\ufe10'),
		gmo_add_diamond('\ufe0f'),
		gmo_add_home('\ufe0e'),
		gmo_add_home_work('\ufe0d'),
		gmo_add_link('\ufe0c'),
		gmo_add_location('\ufe0b'),
		gmo_add_location_alt('\ufe0a'),
		gmo_add_moderator('\ufe09'),
		gmo_add_notes('\ufe08'),
		gmo_add_photo_alternate('\ufe07'),
		gmo_add_reaction('\ufe06'),
		gmo_add_road('\ufe05'),
		gmo_add_shopping_cart('\ufe04'),
		gmo_add_task('\ufe03'),
		gmo_add_to_drive('\ufe02'),
		gmo_add_to_home_screen('\ufe01'),
		gmo_add_to_photos('\ufe00'),
		gmo_add_to_queue('\ufdff'),
		gmo_add_triangle('\ufdfe'),
		gmo_adf_scanner('\ufdfd'),
		gmo_adjust('\ufdfc'),
		gmo_admin_meds('\ufdfb'),
		gmo_admin_panel_settings('\ufdfa'),
		gmo_ads_click('\ufdf9'),
		gmo_agender('\ufdf8'),
		gmo_agriculture('\ufdf7'),
		gmo_air('\ufdf6'),
		gmo_air_freshener('\ufdf5'),
		gmo_air_purifier('\ufdf4'),
		gmo_air_purifier_gen('\ufdf3'),
		gmo_airline_seat_flat('\ufdf2'),
		gmo_airline_seat_flat_angled('\ufdf1'),
		gmo_airline_seat_individual_suite('\ufdf0'),
		gmo_airline_seat_legroom_extra('\ufdef'),
		gmo_airline_seat_legroom_normal('\ufdee'),
		gmo_airline_seat_legroom_reduced('\ufded'),
		gmo_airline_seat_recline_extra('\ufdec'),
		gmo_airline_seat_recline_normal('\ufdeb'),
		gmo_airline_stops('\ufdea'),
		gmo_airlines('\ufde9'),
		gmo_airplane_ticket('\ufde8'),
		gmo_airplanemode_active('\ufde7'),
		gmo_airplanemode_inactive('\ufde6'),
		gmo_airplay('\ufde5'),
		gmo_airport_shuttle('\ufde4'),
		gmo_airware('\ufde3'),
		gmo_airwave('\ufde2'),
		gmo_alarm('\ufde1'),
		gmo_alarm_add('\ufde0'),
		gmo_alarm_off('\ufddf'),
		gmo_alarm_on('\ufdde'),
		gmo_alarm_smart_wake('\ufddd'),
		gmo_album('\ufddc'),
		gmo_align_center('\ufddb'),
		gmo_align_end('\ufdda'),
		gmo_align_flex_center('\ufdd9'),
		gmo_align_flex_end('\ufdd8'),
		gmo_align_flex_start('\ufdd7'),
		gmo_align_horizontal_center('\ufdd6'),
		gmo_align_horizontal_left('\ufdd5'),
		gmo_align_horizontal_right('\ufdd4'),
		gmo_align_items_stretch('\ufdd3'),
		gmo_align_justify_center('\ufdd2'),
		gmo_align_justify_flex_end('\ufdd1'),
		gmo_align_justify_flex_start('\ufdd0'),
		gmo_align_justify_space_around('\ufdcf'),
		gmo_align_justify_space_between('\ufdce'),
		gmo_align_justify_space_even('\ufdcd'),
		gmo_align_justify_stretch('\ufdcc'),
		gmo_align_self_stretch('\ufdcb'),
		gmo_align_space_around('\ufdca'),
		gmo_align_space_between('\ufdc9'),
		gmo_align_space_even('\ufdc8'),
		gmo_align_start('\ufdc7'),
		gmo_align_stretch('\ufdc6'),
		gmo_align_vertical_bottom('\ufdc5'),
		gmo_align_vertical_center('\ufdc4'),
		gmo_align_vertical_top('\ufdc3'),
		gmo_all_inbox('\ufdc2'),
		gmo_all_inclusive('\ufdc1'),
		gmo_all_match('\ufdc0'),
		gmo_all_out('\ufdbf'),
		gmo_allergies('\ufdbe'),
		gmo_allergy('\ufdbd'),
		gmo_alt_route('\ufdbc'),
		gmo_alternate_email('\ufdbb'),
		gmo_altitude('\ufdba'),
		gmo_ambient_screen('\ufdb9'),
		gmo_ambulance('\ufdb8'),
		gmo_amend('\ufdb7'),
		gmo_amp_stories('\ufdb6'),
		gmo_analytics('\ufdb5'),
		gmo_anchor('\ufdb4'),
		gmo_android('\ufdb3'),
		gmo_animated_images('\ufdb2'),
		gmo_animation('\ufdb1'),
		gmo_aod('\ufdb0'),
		gmo_aod_tablet('\ufdaf'),
		gmo_aod_watch('\ufdae'),
		gmo_apartment('\ufdad'),
		gmo_api('\ufdac'),
		gmo_apk_document('\ufdab'),
		gmo_apk_install('\ufdaa'),
		gmo_app_badging('\ufda9'),
		gmo_app_blocking('\ufda8'),
		gmo_app_promo('\ufda7'),
		gmo_app_registration('\ufda6'),
		gmo_app_shortcut('\ufda5'),
		gmo_apparel('\ufda4'),
		gmo_approval('\ufda3'),
		gmo_approval_delegation('\ufda2'),
		gmo_apps('\ufda1'),
		gmo_apps_outage('\ufda0'),
		gmo_aq('\ufd9f'),
		gmo_aq_indoor('\ufd9e'),
		gmo_ar_on_you('\ufd9d'),
		gmo_ar_stickers('\ufd9c'),
		gmo_architecture('\ufd9b'),
		gmo_archive('\ufd9a'),
		gmo_area_chart('\ufd99'),
		gmo_arming_countdown('\ufd98'),
		gmo_arrow_and_edge('\ufd97'),
		gmo_arrow_back('\ufd96'),
		gmo_arrow_back_ios('\ufd95'),
		gmo_arrow_back_ios_new('\ufd94'),
		gmo_arrow_circle_down('\ufd93'),
		gmo_arrow_circle_left('\ufd92'),
		gmo_arrow_circle_right('\ufd91'),
		gmo_arrow_circle_up('\ufd90'),
		gmo_arrow_cool_down('\ufd8f'),
		gmo_arrow_downward('\ufd8e'),
		gmo_arrow_downward_alt('\ufd8d'),
		gmo_arrow_drop_down('\ufd8c'),
		gmo_arrow_drop_down_circle('\ufd8b'),
		gmo_arrow_drop_up('\ufd8a'),
		gmo_arrow_forward('\ufd89'),
		gmo_arrow_forward_ios('\ufd88'),
		gmo_arrow_insert('\ufd87'),
		gmo_arrow_left('\ufd86'),
		gmo_arrow_left_alt('\ufd85'),
		gmo_arrow_or_edge('\ufd84'),
		gmo_arrow_outward('\ufd83'),
		gmo_arrow_range('\ufd82'),
		gmo_arrow_right('\ufd81'),
		gmo_arrow_right_alt('\ufd80'),
		gmo_arrow_selector_tool('\ufd7f'),
		gmo_arrow_split('\ufd7e'),
		gmo_arrow_top_left('\ufd7d'),
		gmo_arrow_top_right('\ufd7c'),
		gmo_arrow_upward('\ufd7b'),
		gmo_arrow_upward_alt('\ufd7a'),
		gmo_arrow_warm_up('\ufd79'),
		gmo_arrows_more_down('\ufd78'),
		gmo_arrows_more_up('\ufd77'),
		gmo_arrows_outward('\ufd76'),
		gmo_art_track('\ufd75'),
		gmo_article('\ufd74'),
		gmo_article_shortcut('\ufd73'),
		gmo_artist('\ufd72'),
		gmo_aspect_ratio('\ufd71'),
		gmo_assignment('\ufd70'),
		gmo_assignment_add('\ufd6f'),
		gmo_assignment_ind('\ufd6e'),
		gmo_assignment_late('\ufd6d'),
		gmo_assignment_return('\ufd6c'),
		gmo_assignment_returned('\ufd6b'),
		gmo_assignment_turned_in('\ufd6a'),
		gmo_assist_walker('\ufd69'),
		gmo_assistant('\ufd68'),
		gmo_assistant_device('\ufd67'),
		gmo_assistant_direction('\ufd66'),
		gmo_assistant_navigation('\ufd65'),
		gmo_assistant_on_hub('\ufd64'),
		gmo_assured_workload('\ufd63'),
		gmo_asterisk('\ufd62'),
		gmo_astrophotography_auto('\ufd61'),
		gmo_astrophotography_off('\ufd60'),
		gmo_atm('\ufd5f'),
		gmo_atr('\ufd5e'),
		gmo_attach_email('\ufd5d'),
		gmo_attach_file('\ufd5c'),
		gmo_attach_file_add('\ufd5b'),
		gmo_attach_file_off('\ufd5a'),
		gmo_attach_money('\ufd59'),
		gmo_attachment('\ufd58'),
		gmo_attractions('\ufd57'),
		gmo_attribution('\ufd56'),
		gmo_audio_description('\ufd55'),
		gmo_audio_file('\ufd54'),
		gmo_audio_video_receiver('\ufd53'),
		gmo_auto_activity_zone('\ufd52'),
		gmo_auto_awesome('\ufd51'),
		gmo_auto_awesome_mosaic('\ufd50'),
		gmo_auto_awesome_motion('\ufd4f'),
		gmo_auto_delete('\ufd4e'),
		gmo_auto_detect_voice('\ufd4d'),
		gmo_auto_fix('\ufd4c'),
		gmo_auto_fix_high('\ufd4b'),
		gmo_auto_fix_normal('\ufd4a'),
		gmo_auto_fix_off('\ufd49'),
		gmo_auto_graph('\ufd48'),
		gmo_auto_label('\ufd47'),
		gmo_auto_meeting_room('\ufd46'),
		gmo_auto_mode('\ufd45'),
		gmo_auto_read_pause('\ufd44'),
		gmo_auto_read_play('\ufd43'),
		gmo_auto_schedule('\ufd42'),
		gmo_auto_stories('\ufd41'),
		gmo_auto_timer('\ufd40'),
		gmo_auto_towing('\ufd3f'),
		gmo_auto_transmission('\ufd3e'),
		gmo_auto_videocam('\ufd3d'),
		gmo_autofps_select('\ufd3c'),
		gmo_autopause('\ufd3b'),
		gmo_autopay('\ufd3a'),
		gmo_autoplay('\ufd39'),
		gmo_autorenew('\ufd38'),
		gmo_autostop('\ufd37'),
		gmo_av1('\ufd36'),
		gmo_av_timer('\ufd35'),
		gmo_avc('\ufd34'),
		gmo_avg_pace('\ufd33'),
		gmo_avg_time('\ufd32'),
		gmo_award_star('\ufd31'),
		gmo_azm('\ufd30'),
		gmo_baby_changing_station('\ufd2f'),
		gmo_back_hand('\ufd2e'),
		gmo_back_to_tab('\ufd2d'),
		gmo_background_blur_full('\ufd2c'),
		gmo_background_blur_light('\ufd2b'),
		gmo_background_dot_large('\ufd2a'),
		gmo_background_dot_small('\ufd29'),
		gmo_background_grid_small('\ufd28'),
		gmo_background_replace('\ufd27'),
		gmo_backlight_high('\ufd26'),
		gmo_backlight_high_off('\ufd25'),
		gmo_backlight_low('\ufd24'),
		gmo_backpack('\ufd23'),
		gmo_backspace('\ufd22'),
		gmo_backup('\ufd21'),
		gmo_backup_table('\ufd20'),
		gmo_badge('\ufd1f'),
		gmo_badge_critical_battery('\ufd1e'),
		gmo_bakery_dining('\ufd1d'),
		gmo_balance('\ufd1c'),
		gmo_balcony('\ufd1b'),
		gmo_ballot('\ufd1a'),
		gmo_bar_chart('\ufd19'),
		gmo_bar_chart_4_bars('\ufd18'),
		gmo_barcode('\ufd17'),
		gmo_barcode_reader('\ufd16'),
		gmo_barcode_scanner('\ufd15'),
		gmo_barefoot('\ufd14'),
		gmo_batch_prediction('\ufd13'),
		gmo_bath_outdoor('\ufd12'),
		gmo_bath_private('\ufd11'),
		gmo_bath_public_large('\ufd10'),
		gmo_bathroom('\ufd0f'),
		gmo_bathtub('\ufd0e'),
		gmo_battery_0_bar('\ufd0d'),
		gmo_battery_1_bar('\ufd0c'),
		gmo_battery_20('\ufd0b'),
		gmo_battery_2_bar('\ufd0a'),
		gmo_battery_30('\ufd09'),
		gmo_battery_3_bar('\ufd08'),
		gmo_battery_4_bar('\ufd07'),
		gmo_battery_50('\ufd06'),
		gmo_battery_5_bar('\ufd05'),
		gmo_battery_60('\ufd04'),
		gmo_battery_6_bar('\ufd03'),
		gmo_battery_80('\ufd02'),
		gmo_battery_90('\ufd01'),
		gmo_battery_alert('\ufd00'),
		gmo_battery_change('\ufcff'),
		gmo_battery_charging_20('\ufcfe'),
		gmo_battery_charging_30('\ufcfd'),
		gmo_battery_charging_50('\ufcfc'),
		gmo_battery_charging_60('\ufcfb'),
		gmo_battery_charging_80('\ufcfa'),
		gmo_battery_charging_90('\ufcf9'),
		gmo_battery_charging_full('\ufcf8'),
		gmo_battery_error('\ufcf7'),
		gmo_battery_full('\ufcf6'),
		gmo_battery_full_alt('\ufcf5'),
		gmo_battery_horiz_000('\ufcf4'),
		gmo_battery_horiz_050('\ufcf3'),
		gmo_battery_horiz_075('\ufcf2'),
		gmo_battery_low('\ufcf1'),
		gmo_battery_plus('\ufcf0'),
		gmo_battery_profile('\ufcef'),
		gmo_battery_saver('\ufcee'),
		gmo_battery_share('\ufced'),
		gmo_battery_status_good('\ufcec'),
		gmo_battery_unknown('\ufceb'),
		gmo_battery_vert_005('\ufcea'),
		gmo_battery_vert_020('\ufce9'),
		gmo_battery_vert_050('\ufce8'),
		gmo_battery_very_low('\ufce7'),
		gmo_beach_access('\ufce6'),
		gmo_bed('\ufce5'),
		gmo_bedroom_baby('\ufce4'),
		gmo_bedroom_child('\ufce3'),
		gmo_bedroom_parent('\ufce2'),
		gmo_bedtime('\ufce1'),
		gmo_bedtime_off('\ufce0'),
		gmo_beenhere('\ufcdf'),
		gmo_bento('\ufcde'),
		gmo_bia('\ufcdd'),
		gmo_bid_landscape('\ufcdc'),
		gmo_bid_landscape_disabled('\ufcdb'),
		gmo_bigtop_updates('\ufcda'),
		gmo_bike_dock('\ufcd9'),
		gmo_bike_lane('\ufcd8'),
		gmo_bike_scooter('\ufcd7'),
		gmo_biotech('\ufcd6'),
		gmo_blanket('\ufcd5'),
		gmo_blender('\ufcd4'),
		gmo_blind('\ufcd3'),
		gmo_blinds('\ufcd2'),
		gmo_blinds_closed('\ufcd1'),
		gmo_block('\ufcd0'),
		gmo_blood_pressure('\ufccf'),
		gmo_bloodtype('\ufcce'),
		gmo_bluetooth('\ufccd'),
		gmo_bluetooth_connected('\ufccc'),
		gmo_bluetooth_disabled('\ufccb'),
		gmo_bluetooth_drive('\ufcca'),
		gmo_bluetooth_searching('\ufcc9'),
		gmo_blur_circular('\ufcc8'),
		gmo_blur_linear('\ufcc7'),
		gmo_blur_medium('\ufcc6'),
		gmo_blur_off('\ufcc5'),
		gmo_blur_on('\ufcc4'),
		gmo_blur_short('\ufcc3'),
		gmo_body_fat('\ufcc2'),
		gmo_body_system('\ufcc1'),
		gmo_bolt('\ufcc0'),
		gmo_bomb('\ufcbf'),
		gmo_book('\ufcbe'),
		gmo_book_2('\ufcbd'),
		gmo_book_3('\ufcbc'),
		gmo_book_4('\ufcbb'),
		gmo_book_5('\ufcba'),
		gmo_book_online('\ufcb9'),
		gmo_bookmark('\ufcb8'),
		gmo_bookmark_add('\ufcb7'),
		gmo_bookmark_added('\ufcb6'),
		gmo_bookmark_check('\ufcb5'),
		gmo_bookmark_flag('\ufcb4'),
		gmo_bookmark_heart('\ufcb3'),
		gmo_bookmark_manager('\ufcb2'),
		gmo_bookmark_remove('\ufcb1'),
		gmo_bookmark_star('\ufcb0'),
		gmo_bookmarks('\ufcaf'),
		gmo_border_all('\ufcae'),
		gmo_border_bottom('\ufcad'),
		gmo_border_clear('\ufcac'),
		gmo_border_color('\ufcab'),
		gmo_border_horizontal('\ufcaa'),
		gmo_border_inner('\ufca9'),
		gmo_border_left('\ufca8'),
		gmo_border_outer('\ufca7'),
		gmo_border_right('\ufca6'),
		gmo_border_style('\ufca5'),
		gmo_border_top('\ufca4'),
		gmo_border_vertical('\ufca3'),
		gmo_bottom_app_bar('\ufca2'),
		gmo_bottom_drawer('\ufca1'),
		gmo_bottom_navigation('\ufca0'),
		gmo_bottom_panel_close('\ufc9f'),
		gmo_bottom_panel_open('\ufc9e'),
		gmo_bottom_right_click('\ufc9d'),
		gmo_bottom_sheets('\ufc9c'),
		gmo_box('\ufc9b'),
		gmo_box_add('\ufc9a'),
		gmo_box_edit('\ufc99'),
		gmo_boy('\ufc98'),
		gmo_brand_awareness('\ufc97'),
		gmo_brand_family('\ufc96'),
		gmo_branding_watermark('\ufc95'),
		gmo_breakfast_dining('\ufc94'),
		gmo_breaking_news('\ufc93'),
		gmo_breaking_news_alt_1('\ufc92'),
		gmo_breastfeeding('\ufc91'),
		gmo_brightness_1('\ufc90'),
		gmo_brightness_2('\ufc8f'),
		gmo_brightness_3('\ufc8e'),
		gmo_brightness_4('\ufc8d'),
		gmo_brightness_5('\ufc8c'),
		gmo_brightness_6('\ufc8b'),
		gmo_brightness_7('\ufc8a'),
		gmo_brightness_alert('\ufc89'),
		gmo_brightness_auto('\ufc88'),
		gmo_brightness_empty('\ufc87'),
		gmo_brightness_high('\ufc86'),
		gmo_brightness_low('\ufc85'),
		gmo_brightness_medium('\ufc84'),
		gmo_bring_your_own_ip('\ufc83'),
		gmo_broadcast_on_home('\ufc82'),
		gmo_broadcast_on_personal('\ufc81'),
		gmo_broken_image('\ufc80'),
		gmo_browse('\ufc7f'),
		gmo_browse_activity('\ufc7e'),
		gmo_browse_gallery('\ufc7d'),
		gmo_browser_updated('\ufc7c'),
		gmo_brunch_dining('\ufc7b'),
		gmo_brush('\ufc7a'),
		gmo_bubble('\ufc79'),
		gmo_bubble_chart('\ufc78'),
		gmo_bubbles('\ufc77'),
		gmo_bug_report('\ufc76'),
		gmo_build('\ufc75'),
		gmo_build_circle('\ufc74'),
		gmo_bungalow('\ufc73'),
		gmo_burst_mode('\ufc72'),
		gmo_bus_alert('\ufc71'),
		gmo_business_center('\ufc70'),
		gmo_business_chip('\ufc6f'),
		gmo_business_messages('\ufc6e'),
		gmo_buttons_alt('\ufc6d'),
		gmo_cabin('\ufc6c'),
		gmo_cable('\ufc6b'),
		gmo_cable_car('\ufc6a'),
		gmo_cached('\ufc69'),
		gmo_cadence('\ufc68'),
		gmo_cake('\ufc67'),
		gmo_cake_add('\ufc66'),
		gmo_calculate('\ufc65'),
		gmo_calendar_add_on('\ufc64'),
		gmo_calendar_apps_script('\ufc63'),
		gmo_calendar_clock('\ufc62'),
		gmo_calendar_month('\ufc61'),
		gmo_calendar_today('\ufc60'),
		gmo_calendar_view_day('\ufc5f'),
		gmo_calendar_view_month('\ufc5e'),
		gmo_calendar_view_week('\ufc5d'),
		gmo_call('\ufc5c'),
		gmo_call_end('\ufc5b'),
		gmo_call_log('\ufc5a'),
		gmo_call_made('\ufc59'),
		gmo_call_merge('\ufc58'),
		gmo_call_missed('\ufc57'),
		gmo_call_missed_outgoing('\ufc56'),
		gmo_call_quality('\ufc55'),
		gmo_call_received('\ufc54'),
		gmo_call_split('\ufc53'),
		gmo_call_to_action('\ufc52'),
		gmo_camera('\ufc51'),
		gmo_camera_enhance('\ufc50'),
		gmo_camera_front('\ufc4f'),
		gmo_camera_indoor('\ufc4e'),
		gmo_camera_outdoor('\ufc4d'),
		gmo_camera_rear('\ufc4c'),
		gmo_camera_roll('\ufc4b'),
		gmo_camera_video('\ufc4a'),
		gmo_cameraswitch('\ufc49'),
		gmo_campaign('\ufc48'),
		gmo_camping('\ufc47'),
		gmo_cancel('\ufc46'),
		gmo_cancel_presentation('\ufc45'),
		gmo_cancel_schedule_send('\ufc44'),
		gmo_candle('\ufc43'),
		gmo_candlestick_chart('\ufc42'),
		gmo_captive_portal('\ufc41'),
		gmo_capture('\ufc40'),
		gmo_car_crash('\ufc3f'),
		gmo_car_rental('\ufc3e'),
		gmo_car_repair('\ufc3d'),
		gmo_car_tag('\ufc3c'),
		gmo_card_membership('\ufc3b'),
		gmo_card_travel('\ufc3a'),
		gmo_cardio_load('\ufc39'),
		gmo_cardiology('\ufc38'),
		gmo_cards('\ufc37'),
		gmo_carpenter('\ufc36'),
		gmo_carry_on_bag('\ufc35'),
		gmo_carry_on_bag_checked('\ufc34'),
		gmo_carry_on_bag_inactive('\ufc33'),
		gmo_carry_on_bag_question('\ufc32'),
		gmo_cases('\ufc31'),
		gmo_casino('\ufc30'),
		gmo_cast('\ufc2f'),
		gmo_cast_connected('\ufc2e'),
		gmo_cast_for_education('\ufc2d'),
		gmo_cast_pause('\ufc2c'),
		gmo_cast_warning('\ufc2b'),
		gmo_castle('\ufc2a'),
		gmo_category('\ufc29'),
		gmo_celebration('\ufc28'),
		gmo_cell_merge('\ufc27'),
		gmo_cell_tower('\ufc26'),
		gmo_cell_wifi('\ufc25'),
		gmo_center_focus_strong('\ufc24'),
		gmo_center_focus_weak('\ufc23'),
		gmo_chair('\ufc22'),
		gmo_chair_alt('\ufc21'),
		gmo_chalet('\ufc20'),
		gmo_change_circle('\ufc1f'),
		gmo_change_history('\ufc1e'),
		gmo_charger('\ufc1d'),
		gmo_charging_station('\ufc1c'),
		gmo_chart_data('\ufc1b'),
		gmo_chat('\ufc1a'),
		gmo_chat_add_on('\ufc19'),
		gmo_chat_apps_script('\ufc18'),
		gmo_chat_bubble('\ufc17'),
		gmo_chat_error('\ufc16'),
		gmo_chat_info('\ufc15'),
		gmo_chat_paste_go('\ufc14'),
		gmo_check('\ufc13'),
		gmo_check_box('\ufc12'),
		gmo_check_box_outline_blank('\ufc11'),
		gmo_check_circle('\ufc10'),
		gmo_check_in_out('\ufc0f'),
		gmo_check_indeterminate_small('\ufc0e'),
		gmo_check_small('\ufc0d'),
		gmo_checkbook('\ufc0c'),
		gmo_checked_bag('\ufc0b'),
		gmo_checked_bag_question('\ufc0a'),
		gmo_checklist('\ufc09'),
		gmo_checklist_rtl('\ufc08'),
		gmo_checkroom('\ufc07'),
		gmo_cheer('\ufc06'),
		gmo_chess('\ufc05'),
		gmo_chevron_backward('\ufc04'),
		gmo_chevron_forward('\ufc03'),
		gmo_chevron_left('\ufc02'),
		gmo_chevron_right('\ufc01'),
		gmo_child_care('\ufc00'),
		gmo_child_friendly('\ufbff'),
		gmo_chip_extraction('\ufbfe'),
		gmo_chips('\ufbfd'),
		gmo_chrome_maximize('\ufbfc'),
		gmo_chrome_minimize('\ufbfb'),
		gmo_chrome_reader_mode('\ufbfa'),
		gmo_chrome_restore('\ufbf9'),
		gmo_chrome_tote('\ufbf8'),
		gmo_chromecast_2('\ufbf7'),
		gmo_chromecast_device('\ufbf6'),
		gmo_chronic('\ufbf5'),
		gmo_church('\ufbf4'),
		gmo_cinematic_blur('\ufbf3'),
		gmo_circle('\ufbf2'),
		gmo_circle_notifications('\ufbf1'),
		gmo_circles('\ufbf0'),
		gmo_circles_ext('\ufbef'),
		gmo_clarify('\ufbee'),
		gmo_clean_hands('\ufbed'),
		gmo_cleaning('\ufbec'),
		gmo_cleaning_bucket('\ufbeb'),
		gmo_cleaning_services('\ufbea'),
		gmo_clear_all('\ufbe9'),
		gmo_clear_day('\ufbe8'),
		gmo_clear_night('\ufbe7'),
		gmo_climate_mini_split('\ufbe6'),
		gmo_clinical_notes('\ufbe5'),
		gmo_clock_loader_10('\ufbe4'),
		gmo_clock_loader_20('\ufbe3'),
		gmo_clock_loader_40('\ufbe2'),
		gmo_clock_loader_60('\ufbe1'),
		gmo_clock_loader_80('\ufbe0'),
		gmo_clock_loader_90('\ufbdf'),
		gmo_close('\ufbde'),
		gmo_close_fullscreen('\ufbdd'),
		gmo_close_small('\ufbdc'),
		gmo_closed_caption('\ufbdb'),
		gmo_closed_caption_add('\ufbda'),
		gmo_closed_caption_disabled('\ufbd9'),
		gmo_cloud('\ufbd8'),
		gmo_cloud_circle('\ufbd7'),
		gmo_cloud_done('\ufbd6'),
		gmo_cloud_download('\ufbd5'),
		gmo_cloud_off('\ufbd4'),
		gmo_cloud_queue('\ufbd3'),
		gmo_cloud_sync('\ufbd2'),
		gmo_cloud_upload('\ufbd1'),
		gmo_cloudy('\ufbd0'),
		gmo_cloudy_filled('\ufbcf'),
		gmo_cloudy_snowing('\ufbce'),
		gmo_co2('\ufbcd'),
		gmo_co_present('\ufbcc'),
		gmo_code('\ufbcb'),
		gmo_code_blocks('\ufbca'),
		gmo_code_off('\ufbc9'),
		gmo_coffee('\ufbc8'),
		gmo_coffee_maker('\ufbc7'),
		gmo_cognition('\ufbc6'),
		gmo_collapse_all('\ufbc5'),
		gmo_collapse_content('\ufbc4'),
		gmo_collections_bookmark('\ufbc3'),
		gmo_colorize('\ufbc2'),
		gmo_colors('\ufbc1'),
		gmo_comedy_mask('\ufbc0'),
		gmo_comic_bubble('\ufbbf'),
		gmo_comment('\ufbbe'),
		gmo_comment_bank('\ufbbd'),
		gmo_comments_disabled('\ufbbc'),
		gmo_commit('\ufbbb'),
		gmo_communication('\ufbba'),
		gmo_communities('\ufbb9'),
		gmo_commute('\ufbb8'),
		gmo_compare('\ufbb7'),
		gmo_compare_arrows('\ufbb6'),
		gmo_compass_calibration('\ufbb5'),
		gmo_component_exchange('\ufbb4'),
		gmo_compost('\ufbb3'),
		gmo_compress('\ufbb2'),
		gmo_computer('\ufbb1'),
		gmo_concierge('\ufbb0'),
		gmo_conditions('\ufbaf'),
		gmo_confirmation_number('\ufbae'),
		gmo_congenital('\ufbad'),
		gmo_connect_without_contact('\ufbac'),
		gmo_connected_tv('\ufbab'),
		gmo_connecting_airports('\ufbaa'),
		gmo_construction('\ufba9'),
		gmo_contact_emergency('\ufba8'),
		gmo_contact_mail('\ufba7'),
		gmo_contact_page('\ufba6'),
		gmo_contact_phone('\ufba5'),
		gmo_contact_support('\ufba4'),
		gmo_contactless('\ufba3'),
		gmo_contactless_off('\ufba2'),
		gmo_contacts('\ufba1'),
		gmo_contacts_product('\ufba0'),
		gmo_content_copy('\ufb9f'),
		gmo_content_cut('\ufb9e'),
		gmo_content_paste('\ufb9d'),
		gmo_content_paste_go('\ufb9c'),
		gmo_content_paste_off('\ufb9b'),
		gmo_content_paste_search('\ufb9a'),
		gmo_contextual_token('\ufb99'),
		gmo_contextual_token_add('\ufb98'),
		gmo_contract('\ufb97'),
		gmo_contract_delete('\ufb96'),
		gmo_contract_edit('\ufb95'),
		gmo_contrast('\ufb94'),
		gmo_contrast_circle('\ufb93'),
		gmo_contrast_rtl_off('\ufb92'),
		gmo_contrast_square('\ufb91'),
		gmo_control_camera('\ufb90'),
		gmo_control_point_duplicate('\ufb8f'),
		gmo_controller_gen('\ufb8e'),
		gmo_conversion_path('\ufb8d'),
		gmo_conversion_path_off('\ufb8c'),
		gmo_conveyor_belt('\ufb8b'),
		gmo_cookie('\ufb8a'),
		gmo_cookie_off('\ufb89'),
		gmo_cooking('\ufb88'),
		gmo_cool_to_dry('\ufb87'),
		gmo_copy_all('\ufb86'),
		gmo_copyright('\ufb85'),
		gmo_coronavirus('\ufb84'),
		gmo_corporate_fare('\ufb83'),
		gmo_cottage('\ufb82'),
		gmo_counter_0('\ufb81'),
		gmo_counter_1('\ufb80'),
		gmo_counter_2('\ufb7f'),
		gmo_counter_3('\ufb7e'),
		gmo_counter_4('\ufb7d'),
		gmo_counter_5('\ufb7c'),
		gmo_counter_6('\ufb7b'),
		gmo_counter_7('\ufb7a'),
		gmo_counter_8('\ufb79'),
		gmo_counter_9('\ufb78'),
		gmo_countertops('\ufb77'),
		gmo_create_new_folder('\ufb76'),
		gmo_credit_card('\ufb75'),
		gmo_credit_card_gear('\ufb74'),
		gmo_credit_card_heart('\ufb73'),
		gmo_credit_card_off('\ufb72'),
		gmo_credit_score('\ufb71'),
		gmo_crib('\ufb70'),
		gmo_crisis_alert('\ufb6f'),
		gmo_crop('\ufb6e'),
		gmo_crop_16_9('\ufb6d'),
		gmo_crop_3_2('\ufb6c'),
		gmo_crop_5_4('\ufb6b'),
		gmo_crop_7_5('\ufb6a'),
		gmo_crop_9_16('\ufb69'),
		gmo_crop_free('\ufb68'),
		gmo_crop_landscape('\ufb67'),
		gmo_crop_portrait('\ufb66'),
		gmo_crop_rotate('\ufb65'),
		gmo_crop_square('\ufb64'),
		gmo_crossword('\ufb63'),
		gmo_crowdsource('\ufb62'),
		gmo_cruelty_free('\ufb61'),
		gmo_css('\ufb60'),
		gmo_csv('\ufb5f'),
		gmo_currency_bitcoin('\ufb5e'),
		gmo_currency_exchange('\ufb5d'),
		gmo_currency_franc('\ufb5c'),
		gmo_currency_lira('\ufb5b'),
		gmo_currency_pound('\ufb5a'),
		gmo_currency_ruble('\ufb59'),
		gmo_currency_rupee('\ufb58'),
		gmo_currency_rupee_circle('\ufb57'),
		gmo_currency_yen('\ufb56'),
		gmo_currency_yuan('\ufb55'),
		gmo_curtains('\ufb54'),
		gmo_curtains_closed('\ufb53'),
		gmo_custom_typography('\ufb52'),
		gmo_cut('\ufb51'),
		gmo_cycle('\ufb50'),
		gmo_cyclone('\ufb4f'),
		gmo_dangerous('\ufb4e'),
		gmo_dark_mode('\ufb4d'),
		gmo_dashboard('\ufb4c'),
		gmo_dashboard_customize('\ufb4b'),
		gmo_data_alert('\ufb4a'),
		gmo_data_array('\ufb49'),
		gmo_data_check('\ufb48'),
		gmo_data_exploration('\ufb47'),
		gmo_data_info_alert('\ufb46'),
		gmo_data_loss_prevention('\ufb45'),
		gmo_data_object('\ufb44'),
		gmo_data_saver_on('\ufb43'),
		gmo_data_table('\ufb42'),
		gmo_data_thresholding('\ufb41'),
		gmo_data_usage('\ufb40'),
		gmo_database('\ufb3f'),
		gmo_dataset('\ufb3e'),
		gmo_dataset_linked('\ufb3d'),
		gmo_date_range('\ufb3c'),
		gmo_deblur('\ufb3b'),
		gmo_deceased('\ufb3a'),
		gmo_decimal_decrease('\ufb39'),
		gmo_decimal_increase('\ufb38'),
		gmo_deck('\ufb37'),
		gmo_dehaze('\ufb36'),
		gmo_delete('\ufb35'),
		gmo_delete_forever('\ufb34'),
		gmo_delete_history('\ufb33'),
		gmo_delete_sweep('\ufb32'),
		gmo_demography('\ufb31'),
		gmo_density_large('\ufb30'),
		gmo_density_medium('\ufb2f'),
		gmo_density_small('\ufb2e'),
		gmo_dentistry('\ufb2d'),
		gmo_departure_board('\ufb2c'),
		gmo_deployed_code('\ufb2b'),
		gmo_deployed_code_account('\ufb2a'),
		gmo_deployed_code_alert('\ufb29'),
		gmo_deployed_code_history('\ufb28'),
		gmo_deployed_code_update('\ufb27'),
		gmo_dermatology('\ufb26'),
		gmo_description('\ufb25'),
		gmo_deselect('\ufb24'),
		gmo_design_services('\ufb23'),
		gmo_desk('\ufb22'),
		gmo_deskphone('\ufb21'),
		gmo_desktop_access_disabled('\ufb20'),
		gmo_desktop_landscape('\ufb1f'),
		gmo_desktop_mac('\ufb1e'),
		gmo_desktop_portrait('\ufb1d'),
		gmo_desktop_windows('\ufb1c'),
		gmo_destruction('\ufb1b'),
		gmo_details('\ufb1a'),
		gmo_detection_and_zone('\ufb19'),
		gmo_detector('\ufb18'),
		gmo_detector_alarm('\ufb17'),
		gmo_detector_battery('\ufb16'),
		gmo_detector_co('\ufb15'),
		gmo_detector_offline('\ufb14'),
		gmo_detector_smoke('\ufb13'),
		gmo_detector_status('\ufb12'),
		gmo_developer_board('\ufb11'),
		gmo_developer_board_off('\ufb10'),
		gmo_developer_guide('\ufb0f'),
		gmo_developer_mode('\ufb0e'),
		gmo_developer_mode_tv('\ufb0d'),
		gmo_device_hub('\ufb0c'),
		gmo_device_reset('\ufb0b'),
		gmo_device_thermostat('\ufb0a'),
		gmo_device_unknown('\ufb09'),
		gmo_devices('\ufb08'),
		gmo_devices_fold('\ufb07'),
		gmo_devices_off('\ufb06'),
		gmo_devices_other('\ufb05'),
		gmo_devices_wearables('\ufb04'),
		gmo_dew_point('\ufb03'),
		gmo_diagnosis('\ufb02'),
		gmo_dialer_sip('\ufb01'),
		gmo_dialogs('\ufb00'),
		gmo_dialpad('\ufaff'),
		gmo_diamond('\ufafe'),
		gmo_dictionary('\ufafd'),
		gmo_difference('\ufafc'),
		gmo_digital_out_of_home('\ufafb'),
		gmo_digital_wellbeing('\ufafa'),
		gmo_dining('\ufaf9'),
		gmo_dinner_dining('\ufaf8'),
		gmo_directions('\ufaf7'),
		gmo_directions_alt('\ufaf6'),
		gmo_directions_alt_off('\ufaf5'),
		gmo_directions_bike('\ufaf4'),
		gmo_directions_boat('\ufaf3'),
		gmo_directions_bus('\ufaf2'),
		gmo_directions_car('\ufaf1'),
		gmo_directions_off('\ufaf0'),
		gmo_directions_railway('\ufaef'),
		gmo_directions_railway_2('\ufaee'),
		gmo_directions_run('\ufaed'),
		gmo_directions_subway('\ufaec'),
		gmo_directions_walk('\ufaeb'),
		gmo_directory_sync('\ufaea'),
		gmo_dirty_lens('\ufae9'),
		gmo_disabled_by_default('\ufae8'),
		gmo_disabled_visible('\ufae7'),
		gmo_disc_full('\ufae6'),
		gmo_discover_tune('\ufae5'),
		gmo_dishwasher('\ufae4'),
		gmo_dishwasher_gen('\ufae3'),
		gmo_display_external_input('\ufae2'),
		gmo_display_settings('\ufae1'),
		gmo_distance('\ufae0'),
		gmo_diversity_1('\ufadf'),
		gmo_diversity_2('\ufade'),
		gmo_diversity_3('\ufadd'),
		gmo_diversity_4('\ufadc'),
		gmo_dns('\ufadb'),
		gmo_do_not_disturb_off('\ufada'),
		gmo_do_not_disturb_on('\ufad9'),
		gmo_do_not_disturb_on_total_silence('\ufad8'),
		gmo_do_not_step('\ufad7'),
		gmo_do_not_touch('\ufad6'),
		gmo_dock('\ufad5'),
		gmo_dock_to_bottom('\ufad4'),
		gmo_dock_to_left('\ufad3'),
		gmo_dock_to_right('\ufad2'),
		gmo_docs_add_on('\ufad1'),
		gmo_docs_apps_script('\ufad0'),
		gmo_document_scanner('\ufacf'),
		gmo_domain('\uface'),
		gmo_domain_add('\ufacd'),
		gmo_domain_disabled('\ufacc'),
		gmo_domain_verification('\ufacb'),
		gmo_domain_verification_off('\ufaca'),
		gmo_domino_mask('\ufac9'),
		gmo_done('\ufac8'),
		gmo_done_all('\ufac7'),
		gmo_done_outline('\ufac6'),
		gmo_donut_large('\ufac5'),
		gmo_donut_small('\ufac4'),
		gmo_door_back('\ufac3'),
		gmo_door_front('\ufac2'),
		gmo_door_open('\ufac1'),
		gmo_door_sensor('\ufac0'),
		gmo_door_sliding('\ufabf'),
		gmo_doorbell('\ufabe'),
		gmo_doorbell_3p('\ufabd'),
		gmo_doorbell_chime('\ufabc'),
		gmo_double_arrow('\ufabb'),
		gmo_downhill_skiing('\ufaba'),
		gmo_download('\ufab9'),
		gmo_download_2('\ufab8'),
		gmo_download_done('\ufab7'),
		gmo_download_for_offline('\ufab6'),
		gmo_downloading('\ufab5'),
		gmo_draft('\ufab4'),
		gmo_draft_orders('\ufab3'),
		gmo_drafts('\ufab2'),
		gmo_drag_click('\ufab1'),
		gmo_drag_handle('\ufab0'),
		gmo_drag_indicator('\ufaaf'),
		gmo_drag_pan('\ufaae'),
		gmo_draw('\ufaad'),
		gmo_draw_abstract('\ufaac'),
		gmo_draw_collage('\ufaab'),
		gmo_dresser('\ufaaa'),
		gmo_drive_file_move('\ufaa9'),
		gmo_drive_file_move_outline('\ufaa8'),
		gmo_drive_file_move_rtl('\ufaa7'),
		gmo_drive_file_rename_outline('\ufaa6'),
		gmo_drive_folder_upload('\ufaa5'),
		gmo_dropdown('\ufaa4'),
		gmo_dry('\ufaa3'),
		gmo_dry_cleaning('\ufaa2'),
		gmo_dual_screen('\ufaa1'),
		gmo_duo('\ufaa0'),
		gmo_dvr('\ufa9f'),
		gmo_dynamic_feed('\ufa9e'),
		gmo_dynamic_form('\ufa9d'),
		gmo_e911_avatar('\ufa9c'),
		gmo_e911_emergency('\ufa9b'),
		gmo_e_mobiledata('\ufa9a'),
		gmo_e_mobiledata_badge('\ufa99'),
		gmo_earbuds('\ufa98'),
		gmo_earbuds_battery('\ufa97'),
		gmo_early_on('\ufa96'),
		gmo_earthquake('\ufa95'),
		gmo_east('\ufa94'),
		gmo_ecg('\ufa93'),
		gmo_ecg_heart('\ufa92'),
		gmo_eco('\ufa91'),
		gmo_eda('\ufa90'),
		gmo_edgesensor_high('\ufa8f'),
		gmo_edgesensor_low('\ufa8e'),
		gmo_edit('\ufa8d'),
		gmo_edit_attributes('\ufa8c'),
		gmo_edit_calendar('\ufa8b'),
		gmo_edit_document('\ufa8a'),
		gmo_edit_location('\ufa89'),
		gmo_edit_location_alt('\ufa88'),
		gmo_edit_note('\ufa87'),
		gmo_edit_notifications('\ufa86'),
		gmo_edit_off('\ufa85'),
		gmo_edit_road('\ufa84'),
		gmo_edit_square('\ufa83'),
		gmo_editor_choice('\ufa82'),
		gmo_egg('\ufa81'),
		gmo_egg_alt('\ufa80'),
		gmo_eject('\ufa7f'),
		gmo_elderly('\ufa7e'),
		gmo_elderly_woman('\ufa7d'),
		gmo_electric_bike('\ufa7c'),
		gmo_electric_bolt('\ufa7b'),
		gmo_electric_car('\ufa7a'),
		gmo_electric_meter('\ufa79'),
		gmo_electric_moped('\ufa78'),
		gmo_electric_rickshaw('\ufa77'),
		gmo_electric_scooter('\ufa76'),
		gmo_electrical_services('\ufa75'),
		gmo_elevation('\ufa74'),
		gmo_elevator('\ufa73'),
		gmo_emergency('\ufa72'),
		gmo_emergency_heat('\ufa71'),
		gmo_emergency_heat_2('\ufa70'),
		gmo_emergency_home('\ufa6f'),
		gmo_emergency_recording('\ufa6e'),
		gmo_emergency_share('\ufa6d'),
		gmo_emergency_share_off('\ufa6c'),
		gmo_emoji_events('\ufa6b'),
		gmo_emoji_flags('\ufa6a'),
		gmo_emoji_food_beverage('\ufa69'),
		gmo_emoji_language('\ufa68'),
		gmo_emoji_nature('\ufa67'),
		gmo_emoji_objects('\ufa66'),
		gmo_emoji_people('\ufa65'),
		gmo_emoji_symbols('\ufa64'),
		gmo_emoji_transportation('\ufa63'),
		gmo_emoticon('\ufa62'),
		gmo_empty_dashboard('\ufa61'),
		gmo_enable('\ufa60'),
		gmo_encrypted('\ufa5f'),
		gmo_endocrinology('\ufa5e'),
		gmo_energy('\ufa5d'),
		gmo_energy_program_saving('\ufa5c'),
		gmo_energy_program_time_used('\ufa5b'),
		gmo_energy_savings_leaf('\ufa5a'),
		gmo_engineering('\ufa59'),
		gmo_enhanced_encryption('\ufa58'),
		gmo_ent('\ufa57'),
		gmo_enterprise('\ufa56'),
		gmo_enterprise_off('\ufa55'),
		gmo_equal('\ufa54'),
		gmo_equalizer('\ufa53'),
		gmo_error('\ufa52'),
		gmo_error_circle_rounded('\ufa51'),
		gmo_error_med('\ufa50'),
		gmo_escalator('\ufa4f'),
		gmo_escalator_warning('\ufa4e'),
		gmo_euro('\ufa4d'),
		gmo_euro_symbol('\ufa4c'),
		gmo_ev_charger('\ufa4b'),
		gmo_ev_mobiledata_badge('\ufa4a'),
		gmo_ev_shadow('\ufa49'),
		gmo_ev_shadow_add('\ufa48'),
		gmo_ev_shadow_minus('\ufa47'),
		gmo_ev_station('\ufa46'),
		gmo_event('\ufa45'),
		gmo_event_available('\ufa44'),
		gmo_event_busy('\ufa43'),
		gmo_event_list('\ufa42'),
		gmo_event_note('\ufa41'),
		gmo_event_repeat('\ufa40'),
		gmo_event_seat('\ufa3f'),
		gmo_event_upcoming('\ufa3e'),
		gmo_exclamation('\ufa3d'),
		gmo_exercise('\ufa3c'),
		gmo_exit_to_app('\ufa3b'),
		gmo_expand('\ufa3a'),
		gmo_expand_all('\ufa39'),
		gmo_expand_circle_down('\ufa38'),
		gmo_expand_circle_right('\ufa37'),
		gmo_expand_circle_up('\ufa36'),
		gmo_expand_content('\ufa35'),
		gmo_expand_less('\ufa34'),
		gmo_expand_more('\ufa33'),
		gmo_experiment('\ufa32'),
		gmo_explicit('\ufa31'),
		gmo_explore('\ufa30'),
		gmo_explore_nearby('\ufa2f'),
		gmo_explore_off('\ufa2e'),
		gmo_explosion('\ufa2d'),
		gmo_export_notes('\ufa2c'),
		gmo_exposure('\ufa2b'),
		gmo_exposure_neg_1('\ufa2a'),
		gmo_exposure_neg_2('\ufa29'),
		gmo_exposure_plus_1('\ufa28'),
		gmo_exposure_plus_2('\ufa27'),
		gmo_exposure_zero('\ufa26'),
		gmo_extension('\ufa25'),
		gmo_extension_off('\ufa24'),
		gmo_eye_tracking('\ufa23'),
		gmo_eyeglasses('\ufa22'),
		gmo_face('\ufa21'),
		gmo_face_2('\ufa20'),
		gmo_face_3('\ufa1f'),
		gmo_face_4('\ufa1e'),
		gmo_face_5('\ufa1d'),
		gmo_face_6('\ufa1c'),
		gmo_face_retouching_natural('\ufa1b'),
		gmo_face_retouching_off('\ufa1a'),
		gmo_fact_check('\ufa19'),
		gmo_factory('\ufa18'),
		gmo_falling('\ufa17'),
		gmo_familiar_face_and_zone('\ufa16'),
		gmo_family_history('\ufa15'),
		gmo_family_home('\ufa14'),
		gmo_family_link('\ufa13'),
		gmo_family_restroom('\ufa12'),
		gmo_family_star('\ufa11'),
		gmo_farsight_digital('\ufa10'),
		gmo_fast_forward('\ufa0f'),
		gmo_fast_rewind('\ufa0e'),
		gmo_fastfood('\ufa0d'),
		gmo_faucet('\ufa0c'),
		gmo_favorite('\ufa0b'),
		gmo_fax('\ufa0a'),
		gmo_feature_search('\ufa09'),
		gmo_featured_play_list('\ufa08'),
		gmo_featured_seasonal_and_gifts('\ufa07'),
		gmo_featured_video('\ufa06'),
		gmo_feed('\ufa05'),
		gmo_feedback('\ufa04'),
		gmo_female('\ufa03'),
		gmo_femur('\ufa02'),
		gmo_femur_alt('\ufa01'),
		gmo_fence('\ufa00'),
		gmo_fertile('\uf9ff'),
		gmo_festival('\uf9fe'),
		gmo_fiber_dvr('\uf9fd'),
		gmo_fiber_manual_record('\uf9fc'),
		gmo_fiber_new('\uf9fb'),
		gmo_fiber_pin('\uf9fa'),
		gmo_fiber_smart_record('\uf9f9'),
		gmo_file_copy('\uf9f8'),
		gmo_file_copy_off('\uf9f7'),
		gmo_file_download('\uf9f6'),
		gmo_file_download_done('\uf9f5'),
		gmo_file_download_off('\uf9f4'),
		gmo_file_map('\uf9f3'),
		gmo_file_open('\uf9f2'),
		gmo_file_present('\uf9f1'),
		gmo_file_save('\uf9f0'),
		gmo_file_save_off('\uf9ef'),
		gmo_file_upload('\uf9ee'),
		gmo_file_upload_off('\uf9ed'),
		gmo_filter('\uf9ec'),
		gmo_filter_1('\uf9eb'),
		gmo_filter_2('\uf9ea'),
		gmo_filter_3('\uf9e9'),
		gmo_filter_4('\uf9e8'),
		gmo_filter_5('\uf9e7'),
		gmo_filter_6('\uf9e6'),
		gmo_filter_7('\uf9e5'),
		gmo_filter_8('\uf9e4'),
		gmo_filter_9('\uf9e3'),
		gmo_filter_9_plus('\uf9e2'),
		gmo_filter_alt('\uf9e1'),
		gmo_filter_alt_off('\uf9e0'),
		gmo_filter_b_and_w('\uf9df'),
		gmo_filter_center_focus('\uf9de'),
		gmo_filter_drama('\uf9dd'),
		gmo_filter_frames('\uf9dc'),
		gmo_filter_hdr('\uf9db'),
		gmo_filter_list('\uf9da'),
		gmo_filter_list_off('\uf9d9'),
		gmo_filter_none('\uf9d8'),
		gmo_filter_retrolux('\uf9d7'),
		gmo_filter_tilt_shift('\uf9d6'),
		gmo_filter_vintage('\uf9d5'),
		gmo_finance('\uf9d4'),
		gmo_finance_chip('\uf9d3'),
		gmo_finance_mode('\uf9d2'),
		gmo_find_in_page('\uf9d1'),
		gmo_find_replace('\uf9d0'),
		gmo_fingerprint('\uf9cf'),
		gmo_fingerprint_off('\uf9ce'),
		gmo_fire_extinguisher('\uf9cd'),
		gmo_fire_hydrant('\uf9cc'),
		gmo_fire_truck('\uf9cb'),
		gmo_fireplace('\uf9ca'),
		gmo_first_page('\uf9c9'),
		gmo_fit_page('\uf9c8'),
		gmo_fit_screen('\uf9c7'),
		gmo_fit_width('\uf9c6'),
		gmo_fitness_center('\uf9c5'),
		gmo_fitness_tracker('\uf9c4'),
		gmo_flag('\uf9c3'),
		gmo_flag_circle('\uf9c2'),
		gmo_flaky('\uf9c1'),
		gmo_flare('\uf9c0'),
		gmo_flash_auto('\uf9bf'),
		gmo_flash_off('\uf9be'),
		gmo_flash_on('\uf9bd'),
		gmo_flashlight_off('\uf9bc'),
		gmo_flashlight_on('\uf9bb'),
		gmo_flatware('\uf9ba'),
		gmo_flex_direction('\uf9b9'),
		gmo_flex_no_wrap('\uf9b8'),
		gmo_flex_wrap('\uf9b7'),
		gmo_flight('\uf9b6'),
		gmo_flight_class('\uf9b5'),
		gmo_flight_land('\uf9b4'),
		gmo_flight_takeoff('\uf9b3'),
		gmo_flights_and_hotels('\uf9b2'),
		gmo_flightsmode('\uf9b1'),
		gmo_flip('\uf9b0'),
		gmo_flip_camera_android('\uf9af'),
		gmo_flip_camera_ios('\uf9ae'),
		gmo_flip_to_back('\uf9ad'),
		gmo_flip_to_front('\uf9ac'),
		gmo_float_landscape('\uf9ab'),
		gmo_float_landscape_2('\uf9aa'),
		gmo_float_portrait('\uf9a9'),
		gmo_float_portrait_2('\uf9a8'),
		gmo_flood('\uf9a7'),
		gmo_floor('\uf9a6'),
		gmo_floor_lamp('\uf9a5'),
		gmo_flourescent('\uf9a4'),
		gmo_flowsheet('\uf9a3'),
		gmo_fluid('\uf9a2'),
		gmo_fluid_balance('\uf9a1'),
		gmo_fluid_med('\uf9a0'),
		gmo_fluorescent('\uf99f'),
		gmo_flutter('\uf99e'),
		gmo_flutter_dash('\uf99d'),
		gmo_flyover('\uf99c'),
		gmo_fmd_bad('\uf99b'),
		gmo_foggy('\uf99a'),
		gmo_folded_hands('\uf999'),
		gmo_folder('\uf998'),
		gmo_folder_copy('\uf997'),
		gmo_folder_data('\uf996'),
		gmo_folder_delete('\uf995'),
		gmo_folder_limited('\uf994'),
		gmo_folder_managed('\uf993'),
		gmo_folder_off('\uf992'),
		gmo_folder_open('\uf991'),
		gmo_folder_shared('\uf990'),
		gmo_folder_special('\uf98f'),
		gmo_folder_supervised('\uf98e'),
		gmo_folder_zip('\uf98d'),
		gmo_follow_the_signs('\uf98c'),
		gmo_font_download('\uf98b'),
		gmo_font_download_off('\uf98a'),
		gmo_food_bank('\uf989'),
		gmo_foot_bones('\uf988'),
		gmo_footprint('\uf987'),
		gmo_for_you('\uf986'),
		gmo_forest('\uf985'),
		gmo_fork_left('\uf984'),
		gmo_fork_right('\uf983'),
		gmo_forklift('\uf982'),
		gmo_format_align_center('\uf981'),
		gmo_format_align_justify('\uf980'),
		gmo_format_align_left('\uf97f'),
		gmo_format_align_right('\uf97e'),
		gmo_format_bold('\uf97d'),
		gmo_format_clear('\uf97c'),
		gmo_format_color_fill('\uf97b'),
		gmo_format_color_reset('\uf97a'),
		gmo_format_color_text('\uf979'),
		gmo_format_h1('\uf978'),
		gmo_format_h2('\uf977'),
		gmo_format_h3('\uf976'),
		gmo_format_h4('\uf975'),
		gmo_format_h5('\uf974'),
		gmo_format_h6('\uf973'),
		gmo_format_image_left('\uf972'),
		gmo_format_image_right('\uf971'),
		gmo_format_indent_decrease('\uf970'),
		gmo_format_indent_increase('\uf96f'),
		gmo_format_ink_highlighter('\uf96e'),
		gmo_format_italic('\uf96d'),
		gmo_format_letter_spacing('\uf96c'),
		gmo_format_letter_spacing_2('\uf96b'),
		gmo_format_letter_spacing_standard('\uf96a'),
		gmo_format_letter_spacing_wide('\uf969'),
		gmo_format_letter_spacing_wider('\uf968'),
		gmo_format_line_spacing('\uf967'),
		gmo_format_list_bulleted('\uf966'),
		gmo_format_list_bulleted_add('\uf965'),
		gmo_format_list_numbered('\uf964'),
		gmo_format_list_numbered_rtl('\uf963'),
		gmo_format_overline('\uf962'),
		gmo_format_paint('\uf961'),
		gmo_format_paragraph('\uf960'),
		gmo_format_quote('\uf95f'),
		gmo_format_shapes('\uf95e'),
		gmo_format_size('\uf95d'),
		gmo_format_strikethrough('\uf95c'),
		gmo_format_text_clip('\uf95b'),
		gmo_format_text_overflow('\uf95a'),
		gmo_format_text_wrap('\uf959'),
		gmo_format_textdirection_l_to_r('\uf958'),
		gmo_format_textdirection_r_to_l('\uf957'),
		gmo_format_textdirection_vertical('\uf956'),
		gmo_format_underlined('\uf955'),
		gmo_format_underlined_squiggle('\uf954'),
		gmo_forms_add_on('\uf953'),
		gmo_forms_apps_script('\uf952'),
		gmo_fort('\uf951'),
		gmo_forum('\uf950'),
		gmo_forward('\uf94f'),
		gmo_forward_10('\uf94e'),
		gmo_forward_30('\uf94d'),
		gmo_forward_5('\uf94c'),
		gmo_forward_circle('\uf94b'),
		gmo_forward_media('\uf94a'),
		gmo_forward_to_inbox('\uf949'),
		gmo_foundation('\uf948'),
		gmo_frame_inspect('\uf947'),
		gmo_frame_person('\uf946'),
		gmo_frame_person_mic('\uf945'),
		gmo_frame_person_off('\uf944'),
		gmo_frame_reload('\uf943'),
		gmo_frame_source('\uf942'),
		gmo_free_cancellation('\uf941'),
		gmo_front_hand('\uf940'),
		gmo_front_loader('\uf93f'),
		gmo_full_coverage('\uf93e'),
		gmo_full_hd('\uf93d'),
		gmo_full_stacked_bar_chart('\uf93c'),
		gmo_fullscreen('\uf93b'),
		gmo_fullscreen_exit('\uf93a'),
		gmo_fullscreen_portrait('\uf939'),
		gmo_function('\uf938'),
		gmo_functions('\uf937'),
		gmo_funicular('\uf936'),
		gmo_g_mobiledata('\uf935'),
		gmo_g_mobiledata_badge('\uf934'),
		gmo_g_translate('\uf933'),
		gmo_gallery_thumbnail('\uf932'),
		gmo_gamepad('\uf931'),
		gmo_garage('\uf930'),
		gmo_garage_door('\uf92f'),
		gmo_garage_home('\uf92e'),
		gmo_garden_cart('\uf92d'),
		gmo_gas_meter('\uf92c'),
		gmo_gastroenterology('\uf92b'),
		gmo_gate('\uf92a'),
		gmo_gavel('\uf929'),
		gmo_general_device('\uf928'),
		gmo_generating_tokens('\uf927'),
		gmo_genetics('\uf926'),
		gmo_genres('\uf925'),
		gmo_gesture('\uf924'),
		gmo_gesture_select('\uf923'),
		gmo_gif('\uf922'),
		gmo_gif_box('\uf921'),
		gmo_girl('\uf920'),
		gmo_gite('\uf91f'),
		gmo_glass_cup('\uf91e'),
		gmo_globe('\uf91d'),
		gmo_globe_asia('\uf91c'),
		gmo_globe_uk('\uf91b'),
		gmo_glucose('\uf91a'),
		gmo_glyphs('\uf919'),
		gmo_go_to_line('\uf918'),
		gmo_golf_course('\uf917'),
		gmo_gondola_lift('\uf916'),
		gmo_google_home_devices('\uf915'),
		gmo_google_plus_reshare('\uf914'),
		gmo_google_tv_remote('\uf913'),
		gmo_google_wifi('\uf912'),
		gmo_gpp_bad('\uf911'),
		gmo_gpp_maybe('\uf910'),
		gmo_grade('\uf90f'),
		gmo_gradient('\uf90e'),
		gmo_grading('\uf90d'),
		gmo_grain('\uf90c'),
		gmo_graphic_eq('\uf90b'),
		gmo_grass('\uf90a'),
		gmo_grid_3x3('\uf909'),
		gmo_grid_3x3_off('\uf908'),
		gmo_grid_4x4('\uf907'),
		gmo_grid_goldenratio('\uf906'),
		gmo_grid_guides('\uf905'),
		gmo_grid_off('\uf904'),
		gmo_grid_on('\uf903'),
		gmo_grid_view('\uf902'),
		gmo_grocery('\uf901'),
		gmo_group('\uf900'),
		gmo_group_add('\uf8ff'),
		gmo_group_auto('\uf8fe'),
		gmo_group_off('\uf8fd'),
		gmo_group_remove('\uf8fc'),
		gmo_group_work('\uf8fb'),
		gmo_grouped_bar_chart('\uf8fa'),
		gmo_groups('\uf8f9'),
		gmo_groups_2('\uf8f8'),
		gmo_groups_3('\uf8f7'),
		gmo_guardian('\uf8f6'),
		gmo_gynecology('\uf8f5'),
		gmo_h_mobiledata('\uf8f4'),
		gmo_h_mobiledata_badge('\uf8f3'),
		gmo_h_plus_mobiledata('\uf8f2'),
		gmo_h_plus_mobiledata_badge('\uf8f1'),
		gmo_hail('\uf8f0'),
		gmo_hallway('\uf8ef'),
		gmo_hand_bones('\uf8ee'),
		gmo_hand_gesture('\uf8ed'),
		gmo_handheld_controller('\uf8ec'),
		gmo_handshake('\uf8eb'),
		gmo_handyman('\uf8ea'),
		gmo_hangout_meeting('\uf8e9'),
		gmo_hangout_video('\uf8e8'),
		gmo_hangout_video_off('\uf8e7'),
		gmo_hard_drive('\uf8e6'),
		gmo_hard_drive_2('\uf8e5'),
		gmo_hardware('\uf8e4'),
		gmo_hd('\uf8e3'),
		gmo_hdr_auto('\uf8e2'),
		gmo_hdr_auto_select('\uf8e1'),
		gmo_hdr_enhanced_select('\uf8e0'),
		gmo_hdr_off('\uf8df'),
		gmo_hdr_off_select('\uf8de'),
		gmo_hdr_on('\uf8dd'),
		gmo_hdr_on_select('\uf8dc'),
		gmo_hdr_plus('\uf8db'),
		gmo_hdr_plus_off('\uf8da'),
		gmo_hdr_strong('\uf8d9'),
		gmo_hdr_weak('\uf8d8'),
		gmo_head_mounted_device('\uf8d7'),
		gmo_headphones('\uf8d6'),
		gmo_headphones_battery('\uf8d5'),
		gmo_headset_mic('\uf8d4'),
		gmo_headset_off('\uf8d3'),
		gmo_healing('\uf8d2'),
		gmo_health_and_beauty('\uf8d1'),
		gmo_health_and_safety('\uf8d0'),
		gmo_health_metrics('\uf8cf'),
		gmo_heap_snapshot_large('\uf8ce'),
		gmo_heap_snapshot_multiple('\uf8cd'),
		gmo_heap_snapshot_thumbnail('\uf8cc'),
		gmo_hearing('\uf8cb'),
		gmo_hearing_aid('\uf8ca'),
		gmo_hearing_disabled('\uf8c9'),
		gmo_heart_broken('\uf8c8'),
		gmo_heart_check('\uf8c7'),
		gmo_heart_minus('\uf8c6'),
		gmo_heart_plus('\uf8c5'),
		gmo_heat('\uf8c4'),
		gmo_heat_pump('\uf8c3'),
		gmo_heat_pump_balance('\uf8c2'),
		gmo_height('\uf8c1'),
		gmo_helicopter('\uf8c0'),
		gmo_help('\uf8bf'),
		gmo_help_center('\uf8be'),
		gmo_help_clinic('\uf8bd'),
		gmo_hematology('\uf8bc'),
		gmo_hevc('\uf8bb'),
		gmo_hexagon('\uf8ba'),
		gmo_hide('\uf8b9'),
		gmo_hide_image('\uf8b8'),
		gmo_hide_source('\uf8b7'),
		gmo_high_density('\uf8b6'),
		gmo_high_quality('\uf8b5'),
		gmo_high_res('\uf8b4'),
		gmo_highlight('\uf8b3'),
		gmo_highlight_keyboard_focus('\uf8b2'),
		gmo_highlight_mouse_cursor('\uf8b1'),
		gmo_highlight_text_cursor('\uf8b0'),
		gmo_highlighter_size_1('\uf8af'),
		gmo_highlighter_size_2('\uf8ae'),
		gmo_highlighter_size_3('\uf8ad'),
		gmo_highlighter_size_4('\uf8ac'),
		gmo_highlighter_size_5('\uf8ab'),
		gmo_hiking('\uf8aa'),
		gmo_history('\uf8a9'),
		gmo_history_edu('\uf8a8'),
		gmo_history_off('\uf8a7'),
		gmo_history_toggle_off('\uf8a6'),
		gmo_hive('\uf8a5'),
		gmo_hls('\uf8a4'),
		gmo_hls_off('\uf8a3'),
		gmo_holiday_village('\uf8a2'),
		gmo_home('\uf8a1'),
		gmo_home_and_garden('\uf8a0'),
		gmo_home_app_logo('\uf89f'),
		gmo_home_health('\uf89e'),
		gmo_home_improvement_and_tools('\uf89d'),
		gmo_home_iot_device('\uf89c'),
		gmo_home_max('\uf89b'),
		gmo_home_max_dots('\uf89a'),
		gmo_home_mini('\uf899'),
		gmo_home_pin('\uf898'),
		gmo_home_repair_service('\uf897'),
		gmo_home_speaker('\uf896'),
		gmo_home_storage('\uf895'),
		gmo_home_work('\uf894'),
		gmo_horizontal_distribute('\uf893'),
		gmo_horizontal_rule('\uf892'),
		gmo_horizontal_split('\uf891'),
		gmo_hot_tub('\uf890'),
		gmo_hotel('\uf88f'),
		gmo_hotel_class('\uf88e'),
		gmo_hourglass('\uf88d'),
		gmo_hourglass_bottom('\uf88c'),
		gmo_hourglass_disabled('\uf88b'),
		gmo_hourglass_empty('\uf88a'),
		gmo_hourglass_full('\uf889'),
		gmo_hourglass_top('\uf888'),
		gmo_house('\uf887'),
		gmo_house_siding('\uf886'),
		gmo_house_with_shield('\uf885'),
		gmo_houseboat('\uf884'),
		gmo_household_supplies('\uf883'),
		gmo_hov('\uf882'),
		gmo_how_to_reg('\uf881'),
		gmo_how_to_vote('\uf880'),
		gmo_hr_resting('\uf87f'),
		gmo_html('\uf87e'),
		gmo_http('\uf87d'),
		gmo_hub('\uf87c'),
		gmo_humerus('\uf87b'),
		gmo_humerus_alt('\uf87a'),
		gmo_humidity_helper('\uf879'),
		gmo_humidity_high('\uf878'),
		gmo_humidity_indoor('\uf877'),
		gmo_humidity_low('\uf876'),
		gmo_humidity_mid('\uf875'),
		gmo_humidity_percentage('\uf874'),
		gmo_hvac('\uf873'),
		gmo_ice_skating('\uf872'),
		gmo_icecream('\uf871'),
		gmo_id_card('\uf870'),
		gmo_ifl('\uf86f'),
		gmo_iframe('\uf86e'),
		gmo_iframe_off('\uf86d'),
		gmo_image('\uf86c'),
		gmo_image_aspect_ratio('\uf86b'),
		gmo_image_not_supported('\uf86a'),
		gmo_image_search('\uf869'),
		gmo_imagesearch_roller('\uf868'),
		gmo_imagesmode('\uf867'),
		gmo_immunology('\uf866'),
		gmo_import_contacts('\uf865'),
		gmo_important_devices('\uf864'),
		gmo_in_home_mode('\uf863'),
		gmo_inactive_order('\uf862'),
		gmo_inbox('\uf861'),
		gmo_inbox_customize('\uf860'),
		gmo_incomplete_circle('\uf85f'),
		gmo_indeterminate_check_box('\uf85e'),
		gmo_indeterminate_question_box('\uf85d'),
		gmo_info('\uf85c'),
		gmo_info_i('\uf85b'),
		gmo_infrared('\uf85a'),
		gmo_ink_eraser('\uf859'),
		gmo_ink_eraser_off('\uf858'),
		gmo_ink_highlighter('\uf857'),
		gmo_ink_highlighter_move('\uf856'),
		gmo_ink_marker('\uf855'),
		gmo_ink_pen('\uf854'),
		gmo_inpatient('\uf853'),
		gmo_input('\uf852'),
		gmo_input_circle('\uf851'),
		gmo_insert_chart('\uf850'),
		gmo_insert_page_break('\uf84f'),
		gmo_insert_text('\uf84e'),
		gmo_insights('\uf84d'),
		gmo_install_desktop('\uf84c'),
		gmo_install_mobile('\uf84b'),
		gmo_instant_mix('\uf84a'),
		gmo_integration_instructions('\uf849'),
		gmo_interactive_space('\uf848'),
		gmo_interests('\uf847'),
		gmo_interpreter_mode('\uf846'),
		gmo_inventory('\uf845'),
		gmo_inventory_2('\uf844'),
		gmo_invert_colors('\uf843'),
		gmo_invert_colors_off('\uf842'),
		gmo_ios('\uf841'),
		gmo_ios_share('\uf840'),
		gmo_iron('\uf83f'),
		gmo_jamboard_kiosk('\uf83e'),
		gmo_javascript('\uf83d'),
		gmo_join('\uf83c'),
		gmo_join_full('\uf83b'),
		gmo_join_inner('\uf83a'),
		gmo_join_left('\uf839'),
		gmo_join_right('\uf838'),
		gmo_joystick('\uf837'),
		gmo_jump_to_element('\uf836'),
		gmo_kayaking('\uf835'),
		gmo_kebab_dining('\uf834'),
		gmo_keep('\uf833'),
		gmo_keep_off('\uf832'),
		gmo_keep_public('\uf831'),
		gmo_kettle('\uf830'),
		gmo_key('\uf82f'),
		gmo_key_off('\uf82e'),
		gmo_key_vertical('\uf82d'),
		gmo_key_visualizer('\uf82c'),
		gmo_keyboard('\uf82b'),
		gmo_keyboard_alt('\uf82a'),
		gmo_keyboard_arrow_down('\uf829'),
		gmo_keyboard_arrow_left('\uf828'),
		gmo_keyboard_arrow_right('\uf827'),
		gmo_keyboard_arrow_up('\uf826'),
		gmo_keyboard_backspace('\uf825'),
		gmo_keyboard_capslock('\uf824'),
		gmo_keyboard_capslock_badge('\uf823'),
		gmo_keyboard_command_key('\uf822'),
		gmo_keyboard_control_key('\uf821'),
		gmo_keyboard_double_arrow_down('\uf820'),
		gmo_keyboard_double_arrow_left('\uf81f'),
		gmo_keyboard_double_arrow_right('\uf81e'),
		gmo_keyboard_double_arrow_up('\uf81d'),
		gmo_keyboard_external_input('\uf81c'),
		gmo_keyboard_full('\uf81b'),
		gmo_keyboard_hide('\uf81a'),
		gmo_keyboard_keys('\uf819'),
		gmo_keyboard_lock('\uf818'),
		gmo_keyboard_lock_off('\uf817'),
		gmo_keyboard_off('\uf816'),
		gmo_keyboard_onscreen('\uf815'),
		gmo_keyboard_option_key('\uf814'),
		gmo_keyboard_previous_language('\uf813'),
		gmo_keyboard_return('\uf812'),
		gmo_keyboard_tab('\uf811'),
		gmo_keyboard_tab_rtl('\uf810'),
		gmo_keyboard_voice('\uf80f'),
		gmo_kid_star('\uf80e'),
		gmo_king_bed('\uf80d'),
		gmo_kitchen('\uf80c'),
		gmo_kitesurfing('\uf80b'),
		gmo_lab_panel('\uf80a'),
		gmo_lab_profile('\uf809'),
		gmo_lab_research('\uf808'),
		gmo_label('\uf807'),
		gmo_label_important('\uf806'),
		gmo_label_off('\uf805'),
		gmo_labs('\uf804'),
		gmo_lan('\uf803'),
		gmo_landscape('\uf802'),
		gmo_landscape_2('\uf801'),
		gmo_landscape_2_off('\uf800'),
		gmo_landslide('\uf7ff'),
		gmo_language('\uf7fe'),
		gmo_language_chinese_array('\uf7fd'),
		gmo_language_chinese_cangjie('\uf7fc'),
		gmo_language_chinese_dayi('\uf7fb'),
		gmo_language_chinese_pinyin('\uf7fa'),
		gmo_language_chinese_quick('\uf7f9'),
		gmo_language_chinese_wubi('\uf7f8'),
		gmo_language_french('\uf7f7'),
		gmo_language_gb_english('\uf7f6'),
		gmo_language_international('\uf7f5'),
		gmo_language_japanese_kana('\uf7f4'),
		gmo_language_korean_latin('\uf7f3'),
		gmo_language_pinyin('\uf7f2'),
		gmo_language_spanish('\uf7f1'),
		gmo_language_us('\uf7f0'),
		gmo_language_us_colemak('\uf7ef'),
		gmo_language_us_dvorak('\uf7ee'),
		gmo_laps('\uf7ed'),
		gmo_laptop_chromebook('\uf7ec'),
		gmo_laptop_mac('\uf7eb'),
		gmo_laptop_windows('\uf7ea'),
		gmo_lasso_select('\uf7e9'),
		gmo_last_page('\uf7e8'),
		gmo_laundry('\uf7e7'),
		gmo_layers('\uf7e6'),
		gmo_layers_clear('\uf7e5'),
		gmo_lda('\uf7e4'),
		gmo_leaderboard('\uf7e3'),
		gmo_leaf_spark('\uf7e2'),
		gmo_leak_add('\uf7e1'),
		gmo_leak_remove('\uf7e0'),
		gmo_left_click('\uf7df'),
		gmo_left_panel_close('\uf7de'),
		gmo_left_panel_open('\uf7dd'),
		gmo_legend_toggle('\uf7dc'),
		gmo_lens('\uf7db'),
		gmo_lens_blur('\uf7da'),
		gmo_letter_switch('\uf7d9'),
		gmo_library_add('\uf7d8'),
		gmo_library_add_check('\uf7d7'),
		gmo_library_books('\uf7d6'),
		gmo_library_music('\uf7d5'),
		gmo_license('\uf7d4'),
		gmo_lift_to_talk('\uf7d3'),
		gmo_light('\uf7d2'),
		gmo_light_group('\uf7d1'),
		gmo_light_mode('\uf7d0'),
		gmo_light_off('\uf7cf'),
		gmo_lightbulb('\uf7ce'),
		gmo_lightbulb_circle('\uf7cd'),
		gmo_lightning_stand('\uf7cc'),
		gmo_line_axis('\uf7cb'),
		gmo_line_curve('\uf7ca'),
		gmo_line_end('\uf7c9'),
		gmo_line_end_arrow('\uf7c8'),
		gmo_line_end_arrow_notch('\uf7c7'),
		gmo_line_end_circle('\uf7c6'),
		gmo_line_end_diamond('\uf7c5'),
		gmo_line_end_square('\uf7c4'),
		gmo_line_start('\uf7c3'),
		gmo_line_start_arrow('\uf7c2'),
		gmo_line_start_arrow_notch('\uf7c1'),
		gmo_line_start_circle('\uf7c0'),
		gmo_line_start_diamond('\uf7bf'),
		gmo_line_start_square('\uf7be'),
		gmo_line_style('\uf7bd'),
		gmo_line_weight('\uf7bc'),
		gmo_linear_scale('\uf7bb'),
		gmo_link('\uf7ba'),
		gmo_link_off('\uf7b9'),
		gmo_linked_camera('\uf7b8'),
		gmo_linked_services('\uf7b7'),
		gmo_liquor('\uf7b6'),
		gmo_list('\uf7b5'),
		gmo_list_alt('\uf7b4'),
		gmo_list_alt_add('\uf7b3'),
		gmo_lists('\uf7b2'),
		gmo_live_help('\uf7b1'),
		gmo_live_tv('\uf7b0'),
		gmo_living('\uf7af'),
		gmo_local_activity('\uf7ae'),
		gmo_local_atm('\uf7ad'),
		gmo_local_bar('\uf7ac'),
		gmo_local_cafe('\uf7ab'),
		gmo_local_car_wash('\uf7aa'),
		gmo_local_convenience_store('\uf7a9'),
		gmo_local_dining('\uf7a8'),
		gmo_local_drink('\uf7a7'),
		gmo_local_fire_department('\uf7a6'),
		gmo_local_florist('\uf7a5'),
		gmo_local_gas_station('\uf7a4'),
		gmo_local_hospital('\uf7a3'),
		gmo_local_laundry_service('\uf7a2'),
		gmo_local_library('\uf7a1'),
		gmo_local_mall('\uf7a0'),
		gmo_local_parking('\uf79f'),
		gmo_local_pharmacy('\uf79e'),
		gmo_local_pizza('\uf79d'),
		gmo_local_police('\uf79c'),
		gmo_local_post_office('\uf79b'),
		gmo_local_see('\uf79a'),
		gmo_local_shipping('\uf799'),
		gmo_local_taxi('\uf798'),
		gmo_location_automation('\uf797'),
		gmo_location_away('\uf796'),
		gmo_location_chip('\uf795'),
		gmo_location_city('\uf794'),
		gmo_location_disabled('\uf793'),
		gmo_location_home('\uf792'),
		gmo_location_off('\uf791'),
		gmo_location_on('\uf790'),
		gmo_location_searching('\uf78f'),
		gmo_lock('\uf78e'),
		gmo_lock_clock('\uf78d'),
		gmo_lock_open('\uf78c'),
		gmo_lock_open_right('\uf78b'),
		gmo_lock_person('\uf78a'),
		gmo_lock_reset('\uf789'),
		gmo_login('\uf788'),
		gmo_logo_dev('\uf787'),
		gmo_logout('\uf786'),
		gmo_looks('\uf785'),
		gmo_looks_3('\uf784'),
		gmo_looks_4('\uf783'),
		gmo_looks_5('\uf782'),
		gmo_looks_6('\uf781'),
		gmo_looks_one('\uf780'),
		gmo_looks_two('\uf77f'),
		gmo_loupe('\uf77e'),
		gmo_low_density('\uf77d'),
		gmo_low_priority('\uf77c'),
		gmo_lowercase('\uf77b'),
		gmo_loyalty('\uf77a'),
		gmo_lte_mobiledata('\uf779'),
		gmo_lte_mobiledata_badge('\uf778'),
		gmo_lte_plus_mobiledata('\uf777'),
		gmo_lte_plus_mobiledata_badge('\uf776'),
		gmo_luggage('\uf775'),
		gmo_lunch_dining('\uf774'),
		gmo_lyrics('\uf773'),
		gmo_macro_auto('\uf772'),
		gmo_macro_off('\uf771'),
		gmo_magic_button('\uf770'),
		gmo_magic_exchange('\uf76f'),
		gmo_magic_tether('\uf76e'),
		gmo_magnification_large('\uf76d'),
		gmo_magnification_small('\uf76c'),
		gmo_magnify_docked('\uf76b'),
		gmo_magnify_fullscreen('\uf76a'),
		gmo_mail('\uf769'),
		gmo_mail_lock('\uf768'),
		gmo_mail_off('\uf767'),
		gmo_male('\uf766'),
		gmo_man('\uf765'),
		gmo_man_2('\uf764'),
		gmo_man_3('\uf763'),
		gmo_man_4('\uf762'),
		gmo_manage_accounts('\uf761'),
		gmo_manage_history('\uf760'),
		gmo_manage_search('\uf75f'),
		gmo_manga('\uf75e'),
		gmo_manufacturing('\uf75d'),
		gmo_map('\uf75c'),
		gmo_maps_ugc('\uf75b'),
		gmo_margin('\uf75a'),
		gmo_mark_as_unread('\uf759'),
		gmo_mark_chat_read('\uf758'),
		gmo_mark_chat_unread('\uf757'),
		gmo_mark_email_read('\uf756'),
		gmo_mark_email_unread('\uf755'),
		gmo_mark_unread_chat_alt('\uf754'),
		gmo_markdown('\uf753'),
		gmo_markdown_copy('\uf752'),
		gmo_markdown_paste('\uf751'),
		gmo_markunread_mailbox('\uf750'),
		gmo_masked_transitions('\uf74f'),
		gmo_masks('\uf74e'),
		gmo_match_case('\uf74d'),
		gmo_match_word('\uf74c'),
		gmo_matter('\uf74b'),
		gmo_maximize('\uf74a'),
		gmo_measuring_tape('\uf749'),
		gmo_media_bluetooth_off('\uf748'),
		gmo_media_bluetooth_on('\uf747'),
		gmo_media_link('\uf746'),
		gmo_media_output('\uf745'),
		gmo_media_output_off('\uf744'),
		gmo_mediation('\uf743'),
		gmo_medical_information('\uf742'),
		gmo_medical_mask('\uf741'),
		gmo_medical_services('\uf740'),
		gmo_medication('\uf73f'),
		gmo_medication_liquid('\uf73e'),
		gmo_meeting_room('\uf73d'),
		gmo_memory('\uf73c'),
		gmo_memory_alt('\uf73b'),
		gmo_menstrual_health('\uf73a'),
		gmo_menu('\uf739'),
		gmo_menu_book('\uf738'),
		gmo_menu_open('\uf737'),
		gmo_merge('\uf736'),
		gmo_merge_type('\uf735'),
		gmo_metabolism('\uf734'),
		gmo_metro('\uf733'),
		gmo_mfg_nest_yale_lock('\uf732'),
		gmo_mic('\uf731'),
		gmo_mic_double('\uf730'),
		gmo_mic_external_off('\uf72f'),
		gmo_mic_external_on('\uf72e'),
		gmo_mic_noise_cancel_high('\uf72d'),
		gmo_mic_noise_cancel_low('\uf72c'),
		gmo_mic_noise_cancel_off('\uf72b'),
		gmo_mic_off('\uf72a'),
		gmo_microbiology('\uf729'),
		gmo_microwave('\uf728'),
		gmo_microwave_gen('\uf727'),
		gmo_military_tech('\uf726'),
		gmo_mimo('\uf725'),
		gmo_mimo_disconnect('\uf724'),
		gmo_mindfulness('\uf723'),
		gmo_minimize('\uf722'),
		gmo_minor_crash('\uf721'),
		gmo_mintmark('\uf720'),
		gmo_missed_video_call('\uf71f'),
		gmo_missing_controller('\uf71e'),
		gmo_mist('\uf71d'),
		gmo_mitre('\uf71c'),
		gmo_mixture_med('\uf71b'),
		gmo_mms('\uf71a'),
		gmo_mobile_friendly('\uf719'),
		gmo_mobile_off('\uf718'),
		gmo_mobile_screen_share('\uf717'),
		gmo_mobiledata_off('\uf716'),
		gmo_mode_comment('\uf715'),
		gmo_mode_cool('\uf714'),
		gmo_mode_cool_off('\uf713'),
		gmo_mode_dual('\uf712'),
		gmo_mode_fan('\uf711'),
		gmo_mode_fan_off('\uf710'),
		gmo_mode_heat('\uf70f'),
		gmo_mode_heat_cool('\uf70e'),
		gmo_mode_heat_off('\uf70d'),
		gmo_mode_night('\uf70c'),
		gmo_mode_of_travel('\uf70b'),
		gmo_mode_off_on('\uf70a'),
		gmo_mode_standby('\uf709'),
		gmo_model_training('\uf708'),
		gmo_monetization_on('\uf707'),
		gmo_money('\uf706'),
		gmo_money_off('\uf705'),
		gmo_monitor('\uf704'),
		gmo_monitor_heart('\uf703'),
		gmo_monitor_weight('\uf702'),
		gmo_monitor_weight_gain('\uf701'),
		gmo_monitor_weight_loss('\uf700'),
		gmo_monitoring('\uf6ff'),
		gmo_monochrome_photos('\uf6fe'),
		gmo_monorail('\uf6fd'),
		gmo_mood('\uf6fc'),
		gmo_mood_bad('\uf6fb'),
		gmo_mop('\uf6fa'),
		gmo_more('\uf6f9'),
		gmo_more_down('\uf6f8'),
		gmo_more_horiz('\uf6f7'),
		gmo_more_time('\uf6f6'),
		gmo_more_up('\uf6f5'),
		gmo_more_vert('\uf6f4'),
		gmo_mosque('\uf6f3'),
		gmo_motion_blur('\uf6f2'),
		gmo_motion_mode('\uf6f1'),
		gmo_motion_photos_auto('\uf6f0'),
		gmo_motion_photos_off('\uf6ef'),
		gmo_motion_photos_on('\uf6ee'),
		gmo_motion_photos_paused('\uf6ed'),
		gmo_motion_sensor_active('\uf6ec'),
		gmo_motion_sensor_alert('\uf6eb'),
		gmo_motion_sensor_idle('\uf6ea'),
		gmo_motion_sensor_urgent('\uf6e9'),
		gmo_motorcycle('\uf6e8'),
		gmo_mountain_flag('\uf6e7'),
		gmo_mouse('\uf6e6'),
		gmo_mouse_lock('\uf6e5'),
		gmo_mouse_lock_off('\uf6e4'),
		gmo_move('\uf6e3'),
		gmo_move_down('\uf6e2'),
		gmo_move_group('\uf6e1'),
		gmo_move_item('\uf6e0'),
		gmo_move_location('\uf6df'),
		gmo_move_selection_down('\uf6de'),
		gmo_move_selection_left('\uf6dd'),
		gmo_move_selection_right('\uf6dc'),
		gmo_move_selection_up('\uf6db'),
		gmo_move_to_inbox('\uf6da'),
		gmo_move_up('\uf6d9'),
		gmo_moved_location('\uf6d8'),
		gmo_movie('\uf6d7'),
		gmo_movie_edit('\uf6d6'),
		gmo_movie_filter('\uf6d5'),
		gmo_movie_info('\uf6d4'),
		gmo_movie_off('\uf6d3'),
		gmo_moving('\uf6d2'),
		gmo_moving_beds('\uf6d1'),
		gmo_moving_ministry('\uf6d0'),
		gmo_mp('\uf6cf'),
		gmo_multicooker('\uf6ce'),
		gmo_multiline_chart('\uf6cd'),
		gmo_multiple_stop('\uf6cc'),
		gmo_museum('\uf6cb'),
		gmo_music_cast('\uf6ca'),
		gmo_music_note('\uf6c9'),
		gmo_music_off('\uf6c8'),
		gmo_music_video('\uf6c7'),
		gmo_my_location('\uf6c6'),
		gmo_mystery('\uf6c5'),
		gmo_nat('\uf6c4'),
		gmo_nature('\uf6c3'),
		gmo_nature_people('\uf6c2'),
		gmo_navigate_before('\uf6c1'),
		gmo_navigate_next('\uf6c0'),
		gmo_navigation('\uf6bf'),
		gmo_near_me('\uf6be'),
		gmo_near_me_disabled('\uf6bd'),
		gmo_nearby('\uf6bc'),
		gmo_nearby_error('\uf6bb'),
		gmo_nearby_off('\uf6ba'),
		gmo_nephrology('\uf6b9'),
		gmo_nest_audio('\uf6b8'),
		gmo_nest_cam_floodlight('\uf6b7'),
		gmo_nest_cam_indoor('\uf6b6'),
		gmo_nest_cam_iq('\uf6b5'),
		gmo_nest_cam_iq_outdoor('\uf6b4'),
		gmo_nest_cam_magnet_mount('\uf6b3'),
		gmo_nest_cam_outdoor('\uf6b2'),
		gmo_nest_cam_stand('\uf6b1'),
		gmo_nest_cam_wall_mount('\uf6b0'),
		gmo_nest_cam_wired_stand('\uf6af'),
		gmo_nest_clock_farsight_analog('\uf6ae'),
		gmo_nest_clock_farsight_digital('\uf6ad'),
		gmo_nest_connect('\uf6ac'),
		gmo_nest_detect('\uf6ab'),
		gmo_nest_display('\uf6aa'),
		gmo_nest_display_max('\uf6a9'),
		gmo_nest_doorbell_visitor('\uf6a8'),
		gmo_nest_eco_leaf('\uf6a7'),
		gmo_nest_farsight_weather('\uf6a6'),
		gmo_nest_found_savings('\uf6a5'),
		gmo_nest_gale_wifi('\uf6a4'),
		gmo_nest_heat_link_e('\uf6a3'),
		gmo_nest_heat_link_gen_3('\uf6a2'),
		gmo_nest_hello_doorbell('\uf6a1'),
		gmo_nest_locator_tag('\uf6a0'),
		gmo_nest_mini('\uf69f'),
		gmo_nest_multi_room('\uf69e'),
		gmo_nest_protect('\uf69d'),
		gmo_nest_remote('\uf69c'),
		gmo_nest_remote_comfort_sensor('\uf69b'),
		gmo_nest_secure_alarm('\uf69a'),
		gmo_nest_sunblock('\uf699'),
		gmo_nest_tag('\uf698'),
		gmo_nest_thermostat('\uf697'),
		gmo_nest_thermostat_e_eu('\uf696'),
		gmo_nest_thermostat_gen_3('\uf695'),
		gmo_nest_thermostat_sensor('\uf694'),
		gmo_nest_thermostat_sensor_eu('\uf693'),
		gmo_nest_thermostat_zirconium_eu('\uf692'),
		gmo_nest_true_radiant('\uf691'),
		gmo_nest_wake_on_approach('\uf690'),
		gmo_nest_wake_on_press('\uf68f'),
		gmo_nest_wifi_gale('\uf68e'),
		gmo_nest_wifi_mistral('\uf68d'),
		gmo_nest_wifi_point('\uf68c'),
		gmo_nest_wifi_point_vento('\uf68b'),
		gmo_nest_wifi_pro('\uf68a'),
		gmo_nest_wifi_pro_2('\uf689'),
		gmo_nest_wifi_router('\uf688'),
		gmo_network_cell('\uf687'),
		gmo_network_check('\uf686'),
		gmo_network_intelligence_history('\uf685'),
		gmo_network_intelligence_update('\uf684'),
		gmo_network_locked('\uf683'),
		gmo_network_manage('\uf682'),
		gmo_network_node('\uf681'),
		gmo_network_ping('\uf680'),
		gmo_network_wifi('\uf67f'),
		gmo_network_wifi_1_bar('\uf67e'),
		gmo_network_wifi_1_bar_locked('\uf67d'),
		gmo_network_wifi_2_bar('\uf67c'),
		gmo_network_wifi_2_bar_locked('\uf67b'),
		gmo_network_wifi_3_bar('\uf67a'),
		gmo_network_wifi_3_bar_locked('\uf679'),
		gmo_network_wifi_locked('\uf678'),
		gmo_neurology('\uf677'),
		gmo_new_label('\uf676'),
		gmo_new_releases('\uf675'),
		gmo_new_window('\uf674'),
		gmo_news('\uf673'),
		gmo_newsmode('\uf672'),
		gmo_newspaper('\uf671'),
		gmo_newsstand('\uf670'),
		gmo_next_plan('\uf66f'),
		gmo_next_week('\uf66e'),
		gmo_nfc('\uf66d'),
		gmo_night_shelter('\uf66c'),
		gmo_night_sight_auto('\uf66b'),
		gmo_night_sight_auto_off('\uf66a'),
		gmo_night_sight_max('\uf669'),
		gmo_nightlife('\uf668'),
		gmo_nightlight('\uf667'),
		gmo_nightlight_badge('\uf666'),
		gmo_nightlight_off('\uf665'),
		gmo_nights_stay('\uf664'),
		gmo_no_accounts('\uf663'),
		gmo_no_adult_content('\uf662'),
		gmo_no_backpack('\uf661'),
		gmo_no_crash('\uf660'),
		gmo_no_drinks('\uf65f'),
		gmo_no_encryption('\uf65e'),
		gmo_no_flash('\uf65d'),
		gmo_no_food('\uf65c'),
		gmo_no_luggage('\uf65b'),
		gmo_no_meals('\uf65a'),
		gmo_no_meeting_room('\uf659'),
		gmo_no_photography('\uf658'),
		gmo_no_sim('\uf657'),
		gmo_no_sound('\uf656'),
		gmo_no_stroller('\uf655'),
		gmo_no_transfer('\uf654'),
		gmo_noise_aware('\uf653'),
		gmo_noise_control_off('\uf652'),
		gmo_noise_control_on('\uf651'),
		gmo_nordic_walking('\uf650'),
		gmo_north('\uf64f'),
		gmo_north_east('\uf64e'),
		gmo_north_west('\uf64d'),
		gmo_not_accessible('\uf64c'),
		gmo_not_accessible_forward('\uf64b'),
		gmo_not_listed_location('\uf64a'),
		gmo_not_started('\uf649'),
		gmo_note('\uf648'),
		gmo_note_add('\uf647'),
		gmo_note_alt('\uf646'),
		gmo_note_stack('\uf645'),
		gmo_note_stack_add('\uf644'),
		gmo_notes('\uf643'),
		gmo_notification_add('\uf642'),
		gmo_notification_important('\uf641'),
		gmo_notification_multiple('\uf640'),
		gmo_notifications('\uf63f'),
		gmo_notifications_active('\uf63e'),
		gmo_notifications_off('\uf63d'),
		gmo_notifications_paused('\uf63c'),
		gmo_notifications_unread('\uf63b'),
		gmo_numbers('\uf63a'),
		gmo_nutrition('\uf639'),
		gmo_ods('\uf638'),
		gmo_odt('\uf637'),
		gmo_offline_bolt('\uf636'),
		gmo_offline_pin('\uf635'),
		gmo_offline_pin_off('\uf634'),
		gmo_offline_share('\uf633'),
		gmo_oil_barrel('\uf632'),
		gmo_on_device_training('\uf631'),
		gmo_on_hub_device('\uf630'),
		gmo_oncology('\uf62f'),
		gmo_online_prediction('\uf62e'),
		gmo_onsen('\uf62d'),
		gmo_opacity('\uf62c'),
		gmo_open_in_browser('\uf62b'),
		gmo_open_in_full('\uf62a'),
		gmo_open_in_new('\uf629'),
		gmo_open_in_new_down('\uf628'),
		gmo_open_in_new_off('\uf627'),
		gmo_open_in_phone('\uf626'),
		gmo_open_jam('\uf625'),
		gmo_open_run('\uf624'),
		gmo_open_with('\uf623'),
		gmo_ophthalmology('\uf622'),
		gmo_oral_disease('\uf621'),
		gmo_order_approve('\uf620'),
		gmo_order_play('\uf61f'),
		gmo_orders('\uf61e'),
		gmo_orthopedics('\uf61d'),
		gmo_other_admission('\uf61c'),
		gmo_other_houses('\uf61b'),
		gmo_outbound('\uf61a'),
		gmo_outbox('\uf619'),
		gmo_outbox_alt('\uf618'),
		gmo_outdoor_garden('\uf617'),
		gmo_outdoor_grill('\uf616'),
		gmo_outgoing_mail('\uf615'),
		gmo_outlet('\uf614'),
		gmo_outpatient('\uf613'),
		gmo_outpatient_med('\uf612'),
		gmo_output('\uf611'),
		gmo_output_circle('\uf610'),
		gmo_oven('\uf60f'),
		gmo_oven_gen('\uf60e'),
		gmo_overview('\uf60d'),
		gmo_overview_key('\uf60c'),
		gmo_oxygen_saturation('\uf60b'),
		gmo_p2p('\uf60a'),
		gmo_pace('\uf609'),
		gmo_pacemaker('\uf608'),
		gmo_package('\uf607'),
		gmo_package_2('\uf606'),
		gmo_padding('\uf605'),
		gmo_page_control('\uf604'),
		gmo_page_info('\uf603'),
		gmo_pageless('\uf602'),
		gmo_pages('\uf601'),
		gmo_pageview('\uf600'),
		gmo_paid('\uf5ff'),
		gmo_palette('\uf5fe'),
		gmo_pallet('\uf5fd'),
		gmo_pan_tool('\uf5fc'),
		gmo_pan_tool_alt('\uf5fb'),
		gmo_pan_zoom('\uf5fa'),
		gmo_panorama('\uf5f9'),
		gmo_panorama_fish_eye('\uf5f8'),
		gmo_panorama_horizontal('\uf5f7'),
		gmo_panorama_photosphere('\uf5f6'),
		gmo_panorama_vertical('\uf5f5'),
		gmo_panorama_wide_angle('\uf5f4'),
		gmo_paragliding('\uf5f3'),
		gmo_park('\uf5f2'),
		gmo_partly_cloudy_day('\uf5f1'),
		gmo_partly_cloudy_night('\uf5f0'),
		gmo_partner_exchange('\uf5ef'),
		gmo_partner_reports('\uf5ee'),
		gmo_party_mode('\uf5ed'),
		gmo_passkey('\uf5ec'),
		gmo_password('\uf5eb'),
		gmo_password_2('\uf5ea'),
		gmo_password_2_off('\uf5e9'),
		gmo_patient_list('\uf5e8'),
		gmo_pattern('\uf5e7'),
		gmo_pause('\uf5e6'),
		gmo_pause_circle('\uf5e5'),
		gmo_pause_presentation('\uf5e4'),
		gmo_payments('\uf5e3'),
		gmo_pdf_off('\uf5e2'),
		gmo_pedal_bike('\uf5e1'),
		gmo_pediatrics('\uf5e0'),
		gmo_pen_size_1('\uf5df'),
		gmo_pen_size_2('\uf5de'),
		gmo_pen_size_3('\uf5dd'),
		gmo_pen_size_4('\uf5dc'),
		gmo_pen_size_5('\uf5db'),
		gmo_pending('\uf5da'),
		gmo_pending_actions('\uf5d9'),
		gmo_pentagon('\uf5d8'),
		gmo_percent('\uf5d7'),
		gmo_performance_max('\uf5d6'),
		gmo_pergola('\uf5d5'),
		gmo_perm_camera_mic('\uf5d4'),
		gmo_perm_contact_calendar('\uf5d3'),
		gmo_perm_data_setting('\uf5d2'),
		gmo_perm_device_information('\uf5d1'),
		gmo_perm_media('\uf5d0'),
		gmo_perm_phone_msg('\uf5cf'),
		gmo_perm_scan_wifi('\uf5ce'),
		gmo_person('\uf5cd'),
		gmo_person_2('\uf5cc'),
		gmo_person_3('\uf5cb'),
		gmo_person_4('\uf5ca'),
		gmo_person_add('\uf5c9'),
		gmo_person_add_disabled('\uf5c8'),
		gmo_person_alert('\uf5c7'),
		gmo_person_apron('\uf5c6'),
		gmo_person_book('\uf5c5'),
		gmo_person_cancel('\uf5c4'),
		gmo_person_celebrate('\uf5c3'),
		gmo_person_check('\uf5c2'),
		gmo_person_edit('\uf5c1'),
		gmo_person_filled('\uf5c0'),
		gmo_person_off('\uf5bf'),
		gmo_person_pin('\uf5be'),
		gmo_person_pin_circle('\uf5bd'),
		gmo_person_play('\uf5bc'),
		gmo_person_raised_hand('\uf5bb'),
		gmo_person_remove('\uf5ba'),
		gmo_person_search('\uf5b9'),
		gmo_personal_bag('\uf5b8'),
		gmo_personal_bag_off('\uf5b7'),
		gmo_personal_bag_question('\uf5b6'),
		gmo_personal_injury('\uf5b5'),
		gmo_personal_places('\uf5b4'),
		gmo_pest_control('\uf5b3'),
		gmo_pest_control_rodent('\uf5b2'),
		gmo_pet_supplies('\uf5b1'),
		gmo_pets('\uf5b0'),
		gmo_phishing('\uf5af'),
		gmo_phone_android('\uf5ae'),
		gmo_phone_bluetooth_speaker('\uf5ad'),
		gmo_phone_callback('\uf5ac'),
		gmo_phone_disabled('\uf5ab'),
		gmo_phone_enabled('\uf5aa'),
		gmo_phone_forwarded('\uf5a9'),
		gmo_phone_in_talk('\uf5a8'),
		gmo_phone_in_talk_watchface_indicator('\uf5a7'),
		gmo_phone_iphone('\uf5a6'),
		gmo_phone_locked('\uf5a5'),
		gmo_phone_missed('\uf5a4'),
		gmo_phone_paused('\uf5a3'),
		gmo_phonelink_erase('\uf5a2'),
		gmo_phonelink_lock('\uf5a1'),
		gmo_phonelink_off('\uf5a0'),
		gmo_phonelink_ring('\uf59f'),
		gmo_phonelink_ring_off('\uf59e'),
		gmo_phonelink_setup('\uf59d'),
		gmo_photo('\uf59c'),
		gmo_photo_album('\uf59b'),
		gmo_photo_auto_merge('\uf59a'),
		gmo_photo_camera('\uf599'),
		gmo_photo_camera_back('\uf598'),
		gmo_photo_camera_front('\uf597'),
		gmo_photo_filter('\uf596'),
		gmo_photo_frame('\uf595'),
		gmo_photo_library('\uf594'),
		gmo_photo_prints('\uf593'),
		gmo_photo_size_select_large('\uf592'),
		gmo_photo_size_select_small('\uf591'),
		gmo_php('\uf590'),
		gmo_physical_therapy('\uf58f'),
		gmo_piano('\uf58e'),
		gmo_piano_off('\uf58d'),
		gmo_picture_as_pdf('\uf58c'),
		gmo_picture_in_picture('\uf58b'),
		gmo_picture_in_picture_alt('\uf58a'),
		gmo_picture_in_picture_center('\uf589'),
		gmo_picture_in_picture_large('\uf588'),
		gmo_picture_in_picture_medium('\uf587'),
		gmo_picture_in_picture_mobile('\uf586'),
		gmo_picture_in_picture_off('\uf585'),
		gmo_picture_in_picture_small('\uf584'),
		gmo_pie_chart('\uf583'),
		gmo_pill('\uf582'),
		gmo_pill_off('\uf581'),
		gmo_pin('\uf580'),
		gmo_pin_drop('\uf57f'),
		gmo_pin_end('\uf57e'),
		gmo_pin_invoke('\uf57d'),
		gmo_pinch('\uf57c'),
		gmo_pinch_zoom_in('\uf57b'),
		gmo_pinch_zoom_out('\uf57a'),
		gmo_pip('\uf579'),
		gmo_pip_exit('\uf578'),
		gmo_pivot_table_chart('\uf577'),
		gmo_pixel_3_3xl_3a('\uf576'),
		gmo_place_item('\uf575'),
		gmo_plagiarism('\uf574'),
		gmo_planner_banner_ad_pt('\uf573'),
		gmo_planner_review('\uf572'),
		gmo_play_arrow('\uf571'),
		gmo_play_circle('\uf570'),
		gmo_play_disabled('\uf56f'),
		gmo_play_for_work('\uf56e'),
		gmo_play_lesson('\uf56d'),
		gmo_play_pause('\uf56c'),
		gmo_play_shapes('\uf56b'),
		gmo_playing_cards('\uf56a'),
		gmo_playlist_add('\uf569'),
		gmo_playlist_add_check('\uf568'),
		gmo_playlist_add_check_circle('\uf567'),
		gmo_playlist_add_circle('\uf566'),
		gmo_playlist_play('\uf565'),
		gmo_playlist_remove('\uf564'),
		gmo_plumbing('\uf563'),
		gmo_podcasts('\uf562'),
		gmo_podiatry('\uf561'),
		gmo_podium('\uf560'),
		gmo_point_of_sale('\uf55f'),
		gmo_point_scan('\uf55e'),
		gmo_poker_chip('\uf55d'),
		gmo_policy('\uf55c'),
		gmo_polyline('\uf55b'),
		gmo_polymer('\uf55a'),
		gmo_pool('\uf559'),
		gmo_portable_wifi_off('\uf558'),
		gmo_portrait_lighting('\uf557'),
		gmo_portrait_lighting_off('\uf556'),
		gmo_position_bottom_left('\uf555'),
		gmo_position_bottom_right('\uf554'),
		gmo_position_top_right('\uf553'),
		gmo_post('\uf552'),
		gmo_post_add('\uf551'),
		gmo_potted_plant('\uf550'),
		gmo_power('\uf54f'),
		gmo_power_input('\uf54e'),
		gmo_power_off('\uf54d'),
		gmo_power_rounded('\uf54c'),
		gmo_power_settings_new('\uf54b'),
		gmo_prayer_times('\uf54a'),
		gmo_precision_manufacturing('\uf549'),
		gmo_pregnancy('\uf548'),
		gmo_pregnant_woman('\uf547'),
		gmo_preliminary('\uf546'),
		gmo_prescriptions('\uf545'),
		gmo_present_to_all('\uf544'),
		gmo_preview('\uf543'),
		gmo_preview_off('\uf542'),
		gmo_price_change('\uf541'),
		gmo_price_check('\uf540'),
		gmo_print('\uf53f'),
		gmo_print_add('\uf53e'),
		gmo_print_connect('\uf53d'),
		gmo_print_disabled('\uf53c'),
		gmo_print_error('\uf53b'),
		gmo_print_lock('\uf53a'),
		gmo_priority('\uf539'),
		gmo_priority_high('\uf538'),
		gmo_privacy('\uf537'),
		gmo_privacy_screen('\uf536'),
		gmo_privacy_screen_off('\uf535'),
		gmo_privacy_tip('\uf534'),
		gmo_private_connectivity('\uf533'),
		gmo_problem('\uf532'),
		gmo_procedure('\uf531'),
		gmo_process_chart('\uf530'),
		gmo_production_quantity_limits('\uf52f'),
		gmo_productivity('\uf52e'),
		gmo_progress_activity('\uf52d'),
		gmo_prompt_suggestion('\uf52c'),
		gmo_propane('\uf52b'),
		gmo_propane_tank('\uf52a'),
		gmo_psychiatry('\uf529'),
		gmo_psychology('\uf528'),
		gmo_psychology_alt('\uf527'),
		gmo_public('\uf526'),
		gmo_public_off('\uf525'),
		gmo_publish('\uf524'),
		gmo_published_with_changes('\uf523'),
		gmo_pulmonology('\uf522'),
		gmo_pulse_alert('\uf521'),
		gmo_punch_clock('\uf520'),
		gmo_push_pin('\uf51f'),
		gmo_qr_code('\uf51e'),
		gmo_qr_code_2('\uf51d'),
		gmo_qr_code_2_add('\uf51c'),
		gmo_qr_code_scanner('\uf51b'),
		gmo_query_stats('\uf51a'),
		gmo_question_exchange('\uf519'),
		gmo_question_mark('\uf518'),
		gmo_queue_music('\uf517'),
		gmo_queue_play_next('\uf516'),
		gmo_quick_phrases('\uf515'),
		gmo_quick_reference('\uf514'),
		gmo_quick_reference_all('\uf513'),
		gmo_quick_reorder('\uf512'),
		gmo_quickreply('\uf511'),
		gmo_quiet_time('\uf510'),
		gmo_quiet_time_active('\uf50f'),
		gmo_quiz('\uf50e'),
		gmo_r_mobiledata('\uf50d'),
		gmo_radar('\uf50c'),
		gmo_radio('\uf50b'),
		gmo_radio_button_checked('\uf50a'),
		gmo_radio_button_partial('\uf509'),
		gmo_radio_button_unchecked('\uf508'),
		gmo_radiology('\uf507'),
		gmo_railway_alert('\uf506'),
		gmo_railway_alert_2('\uf505'),
		gmo_rainy('\uf504'),
		gmo_rainy_heavy('\uf503'),
		gmo_rainy_light('\uf502'),
		gmo_rainy_snow('\uf501'),
		gmo_ramen_dining('\uf500'),
		gmo_ramp_left('\uf4ff'),
		gmo_ramp_right('\uf4fe'),
		gmo_range_hood('\uf4fd'),
		gmo_rate_review('\uf4fc'),
		gmo_raven('\uf4fb'),
		gmo_raw_off('\uf4fa'),
		gmo_raw_on('\uf4f9'),
		gmo_read_more('\uf4f8'),
		gmo_readiness_score('\uf4f7'),
		gmo_real_estate_agent('\uf4f6'),
		gmo_rear_camera('\uf4f5'),
		gmo_rebase('\uf4f4'),
		gmo_rebase_edit('\uf4f3'),
		gmo_receipt('\uf4f2'),
		gmo_receipt_long('\uf4f1'),
		gmo_recent_actors('\uf4f0'),
		gmo_recent_patient('\uf4ef'),
		gmo_recenter('\uf4ee'),
		gmo_recommend('\uf4ed'),
		gmo_record_voice_over('\uf4ec'),
		gmo_rectangle('\uf4eb'),
		gmo_recycling('\uf4ea'),
		gmo_redeem('\uf4e9'),
		gmo_redo('\uf4e8'),
		gmo_reduce_capacity('\uf4e7'),
		gmo_refresh('\uf4e6'),
		gmo_regular_expression('\uf4e5'),
		gmo_relax('\uf4e4'),
		gmo_release_alert('\uf4e3'),
		gmo_remember_me('\uf4e2'),
		gmo_reminder('\uf4e1'),
		gmo_remote_gen('\uf4e0'),
		gmo_remove('\uf4df'),
		gmo_remove_done('\uf4de'),
		gmo_remove_from_queue('\uf4dd'),
		gmo_remove_moderator('\uf4dc'),
		gmo_remove_road('\uf4db'),
		gmo_remove_selection('\uf4da'),
		gmo_remove_shopping_cart('\uf4d9'),
		gmo_reopen_window('\uf4d8'),
		gmo_reorder('\uf4d7'),
		gmo_repartition('\uf4d6'),
		gmo_repeat('\uf4d5'),
		gmo_repeat_on('\uf4d4'),
		gmo_repeat_one('\uf4d3'),
		gmo_repeat_one_on('\uf4d2'),
		gmo_replace_audio('\uf4d1'),
		gmo_replace_image('\uf4d0'),
		gmo_replace_video('\uf4cf'),
		gmo_replay('\uf4ce'),
		gmo_replay_10('\uf4cd'),
		gmo_replay_30('\uf4cc'),
		gmo_replay_5('\uf4cb'),
		gmo_replay_circle_filled('\uf4ca'),
		gmo_reply('\uf4c9'),
		gmo_reply_all('\uf4c8'),
		gmo_report('\uf4c7'),
		gmo_report_off('\uf4c6'),
		gmo_request_page('\uf4c5'),
		gmo_request_quote('\uf4c4'),
		gmo_reset_brightness('\uf4c3'),
		gmo_reset_focus('\uf4c2'),
		gmo_reset_image('\uf4c1'),
		gmo_reset_iso('\uf4c0'),
		gmo_reset_settings('\uf4bf'),
		gmo_reset_shadow('\uf4be'),
		gmo_reset_shutter_speed('\uf4bd'),
		gmo_reset_tv('\uf4bc'),
		gmo_reset_white_balance('\uf4bb'),
		gmo_reset_wrench('\uf4ba'),
		gmo_resize('\uf4b9'),
		gmo_respiratory_rate('\uf4b8'),
		gmo_responsive_layout('\uf4b7'),
		gmo_restart_alt('\uf4b6'),
		gmo_restaurant('\uf4b5'),
		gmo_restaurant_menu('\uf4b4'),
		gmo_restore_from_trash('\uf4b3'),
		gmo_restore_page('\uf4b2'),
		gmo_resume('\uf4b1'),
		gmo_reviews('\uf4b0'),
		gmo_rewarded_ads('\uf4af'),
		gmo_rheumatology('\uf4ae'),
		gmo_rib_cage('\uf4ad'),
		gmo_rice_bowl('\uf4ac'),
		gmo_right_click('\uf4ab'),
		gmo_right_panel_close('\uf4aa'),
		gmo_right_panel_open('\uf4a9'),
		gmo_ring_volume('\uf4a8'),
		gmo_ripples('\uf4a7'),
		gmo_road('\uf4a6'),
		gmo_robot('\uf4a5'),
		gmo_robot_2('\uf4a4'),
		gmo_rocket('\uf4a3'),
		gmo_rocket_launch('\uf4a2'),
		gmo_roller_shades('\uf4a1'),
		gmo_roller_shades_closed('\uf4a0'),
		gmo_roller_skating('\uf49f'),
		gmo_roofing('\uf49e'),
		gmo_room_preferences('\uf49d'),
		gmo_room_service('\uf49c'),
		gmo_rotate_90_degrees_ccw('\uf49b'),
		gmo_rotate_90_degrees_cw('\uf49a'),
		gmo_rotate_left('\uf499'),
		gmo_rotate_right('\uf498'),
		gmo_roundabout_left('\uf497'),
		gmo_roundabout_right('\uf496'),
		gmo_rounded_corner('\uf495'),
		gmo_route('\uf494'),
		gmo_router('\uf493'),
		gmo_routine('\uf492'),
		gmo_rowing('\uf491'),
		gmo_rss_feed('\uf490'),
		gmo_rsvp('\uf48f'),
		gmo_rtt('\uf48e'),
		gmo_rubric('\uf48d'),
		gmo_rule('\uf48c'),
		gmo_rule_folder('\uf48b'),
		gmo_rule_settings('\uf48a'),
		gmo_run_circle('\uf489'),
		gmo_running_with_errors('\uf488'),
		gmo_rv_hookup('\uf487'),
		gmo_sad_tab('\uf486'),
		gmo_safety_check('\uf485'),
		gmo_safety_check_off('\uf484'),
		gmo_safety_divider('\uf483'),
		gmo_sailing('\uf482'),
		gmo_salinity('\uf481'),
		gmo_sanitizer('\uf480'),
		gmo_satellite('\uf47f'),
		gmo_satellite_alt('\uf47e'),
		gmo_sauna('\uf47d'),
		gmo_save('\uf47c'),
		gmo_save_as('\uf47b'),
		gmo_saved_search('\uf47a'),
		gmo_savings('\uf479'),
		gmo_scale('\uf478'),
		gmo_scan('\uf477'),
		gmo_scan_delete('\uf476'),
		gmo_scanner('\uf475'),
		gmo_scatter_plot('\uf474'),
		gmo_scene('\uf473'),
		gmo_schedule('\uf472'),
		gmo_schedule_send('\uf471'),
		gmo_schema('\uf470'),
		gmo_school('\uf46f'),
		gmo_science('\uf46e'),
		gmo_science_off('\uf46d'),
		gmo_scooter('\uf46c'),
		gmo_score('\uf46b'),
		gmo_scoreboard('\uf46a'),
		gmo_screen_lock_landscape('\uf469'),
		gmo_screen_lock_portrait('\uf468'),
		gmo_screen_lock_rotation('\uf467'),
		gmo_screen_record('\uf466'),
		gmo_screen_rotation('\uf465'),
		gmo_screen_rotation_alt('\uf464'),
		gmo_screen_rotation_up('\uf463'),
		gmo_screen_search_desktop('\uf462'),
		gmo_screen_share('\uf461'),
		gmo_screencast('\uf460'),
		gmo_screenshot('\uf45f'),
		gmo_screenshot_frame('\uf45e'),
		gmo_screenshot_keyboard('\uf45d'),
		gmo_screenshot_monitor('\uf45c'),
		gmo_screenshot_region('\uf45b'),
		gmo_screenshot_tablet('\uf45a'),
		gmo_script('\uf459'),
		gmo_scrollable_header('\uf458'),
		gmo_scuba_diving('\uf457'),
		gmo_sd('\uf456'),
		gmo_sd_card('\uf455'),
		gmo_sd_card_alert('\uf454'),
		gmo_sdk('\uf453'),
		gmo_search('\uf452'),
		gmo_search_check('\uf451'),
		gmo_search_check_2('\uf450'),
		gmo_search_hands_free('\uf44f'),
		gmo_search_insights('\uf44e'),
		gmo_search_off('\uf44d'),
		gmo_security('\uf44c'),
		gmo_security_key('\uf44b'),
		gmo_security_update_good('\uf44a'),
		gmo_security_update_warning('\uf449'),
		gmo_segment('\uf448'),
		gmo_select('\uf447'),
		gmo_select_all('\uf446'),
		gmo_select_check_box('\uf445'),
		gmo_select_to_speak('\uf444'),
		gmo_select_window('\uf443'),
		gmo_select_window_2('\uf442'),
		gmo_select_window_off('\uf441'),
		gmo_self_care('\uf440'),
		gmo_self_improvement('\uf43f'),
		gmo_sell('\uf43e'),
		gmo_send('\uf43d'),
		gmo_send_and_archive('\uf43c'),
		gmo_send_money('\uf43b'),
		gmo_send_time_extension('\uf43a'),
		gmo_send_to_mobile('\uf439'),
		gmo_sensor_door('\uf438'),
		gmo_sensor_occupied('\uf437'),
		gmo_sensor_window('\uf436'),
		gmo_sensors('\uf435'),
		gmo_sensors_krx('\uf434'),
		gmo_sensors_krx_off('\uf433'),
		gmo_sensors_off('\uf432'),
		gmo_sentiment_calm('\uf431'),
		gmo_sentiment_content('\uf430'),
		gmo_sentiment_dissatisfied('\uf42f'),
		gmo_sentiment_excited('\uf42e'),
		gmo_sentiment_extremely_dissatisfied('\uf42d'),
		gmo_sentiment_frustrated('\uf42c'),
		gmo_sentiment_neutral('\uf42b'),
		gmo_sentiment_sad('\uf42a'),
		gmo_sentiment_satisfied('\uf429'),
		gmo_sentiment_stressed('\uf428'),
		gmo_sentiment_very_dissatisfied('\uf427'),
		gmo_sentiment_very_satisfied('\uf426'),
		gmo_sentiment_worried('\uf425'),
		gmo_serif('\uf424'),
		gmo_service_toolbox('\uf423'),
		gmo_set_meal('\uf422'),
		gmo_settings('\uf421'),
		gmo_settings_accessibility('\uf420'),
		gmo_settings_account_box('\uf41f'),
		gmo_settings_alert('\uf41e'),
		gmo_settings_applications('\uf41d'),
		gmo_settings_b_roll('\uf41c'),
		gmo_settings_backup_restore('\uf41b'),
		gmo_settings_bluetooth('\uf41a'),
		gmo_settings_brightness('\uf419'),
		gmo_settings_cell('\uf418'),
		gmo_settings_cinematic_blur('\uf417'),
		gmo_settings_ethernet('\uf416'),
		gmo_settings_heart('\uf415'),
		gmo_settings_input_antenna('\uf414'),
		gmo_settings_input_component('\uf413'),
		gmo_settings_input_hdmi('\uf412'),
		gmo_settings_input_svideo('\uf411'),
		gmo_settings_motion_mode('\uf410'),
		gmo_settings_night_sight('\uf40f'),
		gmo_settings_overscan('\uf40e'),
		gmo_settings_panorama('\uf40d'),
		gmo_settings_phone('\uf40c'),
		gmo_settings_photo_camera('\uf40b'),
		gmo_settings_power('\uf40a'),
		gmo_settings_remote('\uf409'),
		gmo_settings_slow_motion('\uf408'),
		gmo_settings_suggest('\uf407'),
		gmo_settings_system_daydream('\uf406'),
		gmo_settings_timelapse('\uf405'),
		gmo_settings_video_camera('\uf404'),
		gmo_settings_voice('\uf403'),
		gmo_settop_component('\uf402'),
		gmo_severe_cold('\uf401'),
		gmo_shadow('\uf400'),
		gmo_shadow_add('\uf3ff'),
		gmo_shadow_minus('\uf3fe'),
		gmo_shape_line('\uf3fd'),
		gmo_shapes('\uf3fc'),
		gmo_share('\uf3fb'),
		gmo_share_location('\uf3fa'),
		gmo_share_off('\uf3f9'),
		gmo_share_reviews('\uf3f8'),
		gmo_share_windows('\uf3f7'),
		gmo_sheets_rtl('\uf3f6'),
		gmo_shelf_auto_hide('\uf3f5'),
		gmo_shelf_position('\uf3f4'),
		gmo_shelves('\uf3f3'),
		gmo_shield('\uf3f2'),
		gmo_shield_lock('\uf3f1'),
		gmo_shield_locked('\uf3f0'),
		gmo_shield_moon('\uf3ef'),
		gmo_shield_person('\uf3ee'),
		gmo_shield_question('\uf3ed'),
		gmo_shield_spark('\uf3ec'),
		gmo_shield_with_heart('\uf3eb'),
		gmo_shield_with_house('\uf3ea'),
		gmo_shift('\uf3e9'),
		gmo_shift_lock('\uf3e8'),
		gmo_shift_lock_off('\uf3e7'),
		gmo_shop('\uf3e6'),
		gmo_shop_two('\uf3e5'),
		gmo_shopping_bag('\uf3e4'),
		gmo_shopping_basket('\uf3e3'),
		gmo_shopping_cart('\uf3e2'),
		gmo_shopping_cart_checkout('\uf3e1'),
		gmo_shopping_cart_off('\uf3e0'),
		gmo_shoppingmode('\uf3df'),
		gmo_short_stay('\uf3de'),
		gmo_short_text('\uf3dd'),
		gmo_show_chart('\uf3dc'),
		gmo_shower('\uf3db'),
		gmo_shuffle('\uf3da'),
		gmo_shuffle_on('\uf3d9'),
		gmo_shutter_speed('\uf3d8'),
		gmo_shutter_speed_add('\uf3d7'),
		gmo_shutter_speed_minus('\uf3d6'),
		gmo_sick('\uf3d5'),
		gmo_side_navigation('\uf3d4'),
		gmo_sign_language('\uf3d3'),
		gmo_signal_cellular_0_bar('\uf3d2'),
		gmo_signal_cellular_1_bar('\uf3d1'),
		gmo_signal_cellular_2_bar('\uf3d0'),
		gmo_signal_cellular_3_bar('\uf3cf'),
		gmo_signal_cellular_4_bar('\uf3ce'),
		gmo_signal_cellular_add('\uf3cd'),
		gmo_signal_cellular_alt('\uf3cc'),
		gmo_signal_cellular_alt_1_bar('\uf3cb'),
		gmo_signal_cellular_alt_2_bar('\uf3ca'),
		gmo_signal_cellular_connected_no_internet_0_bar('\uf3c9'),
		gmo_signal_cellular_connected_no_internet_4_bar('\uf3c8'),
		gmo_signal_cellular_nodata('\uf3c7'),
		gmo_signal_cellular_null('\uf3c6'),
		gmo_signal_cellular_off('\uf3c5'),
		gmo_signal_cellular_pause('\uf3c4'),
		gmo_signal_disconnected('\uf3c3'),
		gmo_signal_wifi_0_bar('\uf3c2'),
		gmo_signal_wifi_4_bar('\uf3c1'),
		gmo_signal_wifi_bad('\uf3c0'),
		gmo_signal_wifi_off('\uf3bf'),
		gmo_signal_wifi_statusbar_not_connected('\uf3be'),
		gmo_signal_wifi_statusbar_null('\uf3bd'),
		gmo_signature('\uf3bc'),
		gmo_signpost('\uf3bb'),
		gmo_sim_card('\uf3ba'),
		gmo_sim_card_download('\uf3b9'),
		gmo_single_bed('\uf3b8'),
		gmo_sip('\uf3b7'),
		gmo_skateboarding('\uf3b6'),
		gmo_skeleton('\uf3b5'),
		gmo_skillet('\uf3b4'),
		gmo_skillet_cooktop('\uf3b3'),
		gmo_skip_next('\uf3b2'),
		gmo_skip_previous('\uf3b1'),
		gmo_skull('\uf3b0'),
		gmo_slab_serif('\uf3af'),
		gmo_sledding('\uf3ae'),
		gmo_sleep('\uf3ad'),
		gmo_sleep_score('\uf3ac'),
		gmo_slide_library('\uf3ab'),
		gmo_sliders('\uf3aa'),
		gmo_slideshow('\uf3a9'),
		gmo_slow_motion_video('\uf3a8'),
		gmo_smart_button('\uf3a7'),
		gmo_smart_card_reader('\uf3a6'),
		gmo_smart_card_reader_off('\uf3a5'),
		gmo_smart_display('\uf3a4'),
		gmo_smart_outlet('\uf3a3'),
		gmo_smart_screen('\uf3a2'),
		gmo_smart_toy('\uf3a1'),
		gmo_smart_ventilation('\uf3a0'),
		gmo_smartphone('\uf39f'),
		gmo_smartphone_camera('\uf39e'),
		gmo_smb_share('\uf39d'),
		gmo_smoke_free('\uf39c'),
		gmo_smoking_rooms('\uf39b'),
		gmo_sms('\uf39a'),
		gmo_sms_failed('\uf399'),
		gmo_snippet_folder('\uf398'),
		gmo_snooze('\uf397'),
		gmo_snowboarding('\uf396'),
		gmo_snowing('\uf395'),
		gmo_snowing_heavy('\uf394'),
		gmo_snowmobile('\uf393'),
		gmo_snowshoeing('\uf392'),
		gmo_soap('\uf391'),
		gmo_social_distance('\uf390'),
		gmo_social_leaderboard('\uf38f'),
		gmo_solar_power('\uf38e'),
		gmo_sort('\uf38d'),
		gmo_sort_by_alpha('\uf38c'),
		gmo_sos('\uf38b'),
		gmo_sound_detection_dog_barking('\uf38a'),
		gmo_sound_detection_glass_break('\uf389'),
		gmo_sound_detection_loud_sound('\uf388'),
		gmo_sound_sampler('\uf387'),
		gmo_soup_kitchen('\uf386'),
		gmo_source_environment('\uf385'),
		gmo_source_notes('\uf384'),
		gmo_south('\uf383'),
		gmo_south_america('\uf382'),
		gmo_south_east('\uf381'),
		gmo_south_west('\uf380'),
		gmo_spa('\uf37f'),
		gmo_space_bar('\uf37e'),
		gmo_space_dashboard('\uf37d'),
		gmo_spatial_audio('\uf37c'),
		gmo_spatial_audio_off('\uf37b'),
		gmo_spatial_speaker('\uf37a'),
		gmo_spatial_tracking('\uf379'),
		gmo_speaker('\uf378'),
		gmo_speaker_group('\uf377'),
		gmo_speaker_notes('\uf376'),
		gmo_speaker_notes_off('\uf375'),
		gmo_speaker_phone('\uf374'),
		gmo_special_character('\uf373'),
		gmo_specific_gravity('\uf372'),
		gmo_speech_to_text('\uf371'),
		gmo_speed('\uf370'),
		gmo_speed_0_25('\uf36f'),
		gmo_speed_0_2x('\uf36e'),
		gmo_speed_0_5('\uf36d'),
		gmo_speed_0_5x('\uf36c'),
		gmo_speed_0_75('\uf36b'),
		gmo_speed_0_7x('\uf36a'),
		gmo_speed_1_2('\uf369'),
		gmo_speed_1_25('\uf368'),
		gmo_speed_1_2x('\uf367'),
		gmo_speed_1_5('\uf366'),
		gmo_speed_1_5x('\uf365'),
		gmo_speed_1_75('\uf364'),
		gmo_speed_1_7x('\uf363'),
		gmo_speed_2x('\uf362'),
		gmo_speed_camera('\uf361'),
		gmo_spellcheck('\uf360'),
		gmo_splitscreen('\uf35f'),
		gmo_splitscreen_add('\uf35e'),
		gmo_splitscreen_bottom('\uf35d'),
		gmo_splitscreen_landscape('\uf35c'),
		gmo_splitscreen_left('\uf35b'),
		gmo_splitscreen_portrait('\uf35a'),
		gmo_splitscreen_right('\uf359'),
		gmo_splitscreen_top('\uf358'),
		gmo_splitscreen_vertical_add('\uf357'),
		gmo_spo2('\uf356'),
		gmo_spoke('\uf355'),
		gmo_spoof('\uf354'),
		gmo_sports('\uf353'),
		gmo_sports_and_outdoors('\uf352'),
		gmo_sports_bar('\uf351'),
		gmo_sports_baseball('\uf350'),
		gmo_sports_basketball('\uf34f'),
		gmo_sports_cricket('\uf34e'),
		gmo_sports_esports('\uf34d'),
		gmo_sports_football('\uf34c'),
		gmo_sports_golf('\uf34b'),
		gmo_sports_gymnastics('\uf34a'),
		gmo_sports_handball('\uf349'),
		gmo_sports_hockey('\uf348'),
		gmo_sports_kabaddi('\uf347'),
		gmo_sports_martial_arts('\uf346'),
		gmo_sports_mma('\uf345'),
		gmo_sports_motorsports('\uf344'),
		gmo_sports_rugby('\uf343'),
		gmo_sports_score('\uf342'),
		gmo_sports_soccer('\uf341'),
		gmo_sports_tennis('\uf340'),
		gmo_sports_volleyball('\uf33f'),
		gmo_sprinkler('\uf33e'),
		gmo_sprint('\uf33d'),
		gmo_square('\uf33c'),
		gmo_square_foot('\uf33b'),
		gmo_ssid_chart('\uf33a'),
		gmo_stack('\uf339'),
		gmo_stack_off('\uf338'),
		gmo_stack_star('\uf337'),
		gmo_stacked_bar_chart('\uf336'),
		gmo_stacked_email('\uf335'),
		gmo_stacked_inbox('\uf334'),
		gmo_stacked_line_chart('\uf333'),
		gmo_stacks('\uf332'),
		gmo_stadia_controller('\uf331'),
		gmo_stadium('\uf330'),
		gmo_stairs('\uf32f'),
		gmo_stairs_2('\uf32e'),
		gmo_star('\uf32d'),
		gmo_star_half('\uf32c'),
		gmo_star_rate('\uf32b'),
		gmo_star_rate_half('\uf32a'),
		gmo_stars('\uf329'),
		gmo_start('\uf328'),
		gmo_stat_0('\uf327'),
		gmo_stat_1('\uf326'),
		gmo_stat_2('\uf325'),
		gmo_stat_3('\uf324'),
		gmo_stat_minus_1('\uf323'),
		gmo_stat_minus_2('\uf322'),
		gmo_stat_minus_3('\uf321'),
		gmo_stay_current_landscape('\uf320'),
		gmo_stay_current_portrait('\uf31f'),
		gmo_stay_primary_landscape('\uf31e'),
		gmo_stay_primary_portrait('\uf31d'),
		gmo_step('\uf31c'),
		gmo_step_into('\uf31b'),
		gmo_step_out('\uf31a'),
		gmo_step_over('\uf319'),
		gmo_steppers('\uf318'),
		gmo_steps('\uf317'),
		gmo_stethoscope('\uf316'),
		gmo_stethoscope_arrow('\uf315'),
		gmo_stethoscope_check('\uf314'),
		gmo_sticky_note('\uf313'),
		gmo_sticky_note_2('\uf312'),
		gmo_stock_media('\uf311'),
		gmo_stockpot('\uf310'),
		gmo_stop('\uf30f'),
		gmo_stop_circle('\uf30e'),
		gmo_stop_screen_share('\uf30d'),
		gmo_storage('\uf30c'),
		gmo_store('\uf30b'),
		gmo_storefront('\uf30a'),
		gmo_storm('\uf309'),
		gmo_straight('\uf308'),
		gmo_straighten('\uf307'),
		gmo_strategy('\uf306'),
		gmo_stream('\uf305'),
		gmo_stream_apps('\uf304'),
		gmo_streetview('\uf303'),
		gmo_stress_management('\uf302'),
		gmo_strikethrough_s('\uf301'),
		gmo_stroke_full('\uf300'),
		gmo_stroke_partial('\uf2ff'),
		gmo_stroller('\uf2fe'),
		gmo_style('\uf2fd'),
		gmo_styler('\uf2fc'),
		gmo_stylus('\uf2fb'),
		gmo_stylus_laser_pointer('\uf2fa'),
		gmo_stylus_note('\uf2f9'),
		gmo_subdirectory_arrow_left('\uf2f8'),
		gmo_subdirectory_arrow_right('\uf2f7'),
		gmo_subheader('\uf2f6'),
		gmo_subject('\uf2f5'),
		gmo_subscript('\uf2f4'),
		gmo_subscriptions('\uf2f3'),
		gmo_subtitles('\uf2f2'),
		gmo_subtitles_off('\uf2f1'),
		gmo_subway('\uf2f0'),
		gmo_summarize('\uf2ef'),
		gmo_sunny('\uf2ee'),
		gmo_sunny_snowing('\uf2ed'),
		gmo_superscript('\uf2ec'),
		gmo_supervised_user_circle('\uf2eb'),
		gmo_supervised_user_circle_off('\uf2ea'),
		gmo_supervisor_account('\uf2e9'),
		gmo_support('\uf2e8'),
		gmo_support_agent('\uf2e7'),
		gmo_surfing('\uf2e6'),
		gmo_surgical('\uf2e5'),
		gmo_surround_sound('\uf2e4'),
		gmo_swap_calls('\uf2e3'),
		gmo_swap_driving_apps('\uf2e2'),
		gmo_swap_driving_apps_wheel('\uf2e1'),
		gmo_swap_horiz('\uf2e0'),
		gmo_swap_horizontal_circle('\uf2df'),
		gmo_swap_vert('\uf2de'),
		gmo_swap_vertical_circle('\uf2dd'),
		gmo_sweep('\uf2dc'),
		gmo_swipe('\uf2db'),
		gmo_swipe_down('\uf2da'),
		gmo_swipe_down_alt('\uf2d9'),
		gmo_swipe_left('\uf2d8'),
		gmo_swipe_left_alt('\uf2d7'),
		gmo_swipe_right('\uf2d6'),
		gmo_swipe_right_alt('\uf2d5'),
		gmo_swipe_up('\uf2d4'),
		gmo_swipe_up_alt('\uf2d3'),
		gmo_swipe_vertical('\uf2d2'),
		gmo_switch('\uf2d1'),
		gmo_switch_access('\uf2d0'),
		gmo_switch_access_2('\uf2cf'),
		gmo_switch_access_shortcut('\uf2ce'),
		gmo_switch_access_shortcut_add('\uf2cd'),
		gmo_switch_account('\uf2cc'),
		gmo_switch_camera('\uf2cb'),
		gmo_switch_left('\uf2ca'),
		gmo_switch_right('\uf2c9'),
		gmo_switch_video('\uf2c8'),
		gmo_switches('\uf2c7'),
		gmo_sword_rose('\uf2c6'),
		gmo_swords('\uf2c5'),
		gmo_symptoms('\uf2c4'),
		gmo_synagogue('\uf2c3'),
		gmo_sync('\uf2c2'),
		gmo_sync_alt('\uf2c1'),
		gmo_sync_disabled('\uf2c0'),
		gmo_sync_lock('\uf2bf'),
		gmo_sync_problem('\uf2be'),
		gmo_sync_saved_locally('\uf2bd'),
		gmo_syringe('\uf2bc'),
		gmo_system_update('\uf2bb'),
		gmo_system_update_alt('\uf2ba'),
		gmo_tab('\uf2b9'),
		gmo_tab_close('\uf2b8'),
		gmo_tab_close_right('\uf2b7'),
		gmo_tab_duplicate('\uf2b6'),
		gmo_tab_group('\uf2b5'),
		gmo_tab_inactive('\uf2b4'),
		gmo_tab_move('\uf2b3'),
		gmo_tab_new_right('\uf2b2'),
		gmo_tab_recent('\uf2b1'),
		gmo_tab_unselected('\uf2b0'),
		gmo_table('\uf2af'),
		gmo_table_bar('\uf2ae'),
		gmo_table_chart('\uf2ad'),
		gmo_table_chart_view('\uf2ac'),
		gmo_table_eye('\uf2ab'),
		gmo_table_lamp('\uf2aa'),
		gmo_table_restaurant('\uf2a9'),
		gmo_table_rows('\uf2a8'),
		gmo_table_rows_narrow('\uf2a7'),
		gmo_table_view('\uf2a6'),
		gmo_tablet('\uf2a5'),
		gmo_tablet_android('\uf2a4'),
		gmo_tablet_camera('\uf2a3'),
		gmo_tablet_mac('\uf2a2'),
		gmo_tabs('\uf2a1'),
		gmo_tactic('\uf2a0'),
		gmo_tag('\uf29f'),
		gmo_takeout_dining('\uf29e'),
		gmo_tamper_detection_off('\uf29d'),
		gmo_tamper_detection_on('\uf29c'),
		gmo_tap_and_play('\uf29b'),
		gmo_tapas('\uf29a'),
		gmo_target('\uf299'),
		gmo_task('\uf298'),
		gmo_task_alt('\uf297'),
		gmo_taunt('\uf296'),
		gmo_taxi_alert('\uf295'),
		gmo_team_dashboard('\uf294'),
		gmo_temp_preferences_custom('\uf293'),
		gmo_temp_preferences_eco('\uf292'),
		gmo_temple_buddhist('\uf291'),
		gmo_temple_hindu('\uf290'),
		gmo_tenancy('\uf28f'),
		gmo_terminal('\uf28e'),
		gmo_text_ad('\uf28d'),
		gmo_text_decrease('\uf28c'),
		gmo_text_fields('\uf28b'),
		gmo_text_fields_alt('\uf28a'),
		gmo_text_format('\uf289'),
		gmo_text_increase('\uf288'),
		gmo_text_rotate_up('\uf287'),
		gmo_text_rotate_vertical('\uf286'),
		gmo_text_rotation_angledown('\uf285'),
		gmo_text_rotation_angleup('\uf284'),
		gmo_text_rotation_down('\uf283'),
		gmo_text_rotation_none('\uf282'),
		gmo_text_select_end('\uf281'),
		gmo_text_select_jump_to_beginning('\uf280'),
		gmo_text_select_jump_to_end('\uf27f'),
		gmo_text_select_move_back_character('\uf27e'),
		gmo_text_select_move_back_word('\uf27d'),
		gmo_text_select_move_down('\uf27c'),
		gmo_text_select_move_forward_character('\uf27b'),
		gmo_text_select_move_forward_word('\uf27a'),
		gmo_text_select_move_up('\uf279'),
		gmo_text_select_start('\uf278'),
		gmo_text_snippet('\uf277'),
		gmo_text_to_speech('\uf276'),
		gmo_text_up('\uf275'),
		gmo_texture('\uf274'),
		gmo_texture_add('\uf273'),
		gmo_texture_minus('\uf272'),
		gmo_theater_comedy('\uf271'),
		gmo_theaters('\uf270'),
		gmo_thermometer('\uf26f'),
		gmo_thermometer_add('\uf26e'),
		gmo_thermometer_gain('\uf26d'),
		gmo_thermometer_loss('\uf26c'),
		gmo_thermometer_minus('\uf26b'),
		gmo_thermostat('\uf26a'),
		gmo_thermostat_auto('\uf269'),
		gmo_thermostat_carbon('\uf268'),
		gmo_things_to_do('\uf267'),
		gmo_thread_unread('\uf266'),
		gmo_thumb_down('\uf265'),
		gmo_thumb_down_off('\uf264'),
		gmo_thumb_up('\uf263'),
		gmo_thumb_up_off('\uf262'),
		gmo_thumbnail_bar('\uf261'),
		gmo_thumbs_up_down('\uf260'),
		gmo_thunderstorm('\uf25f'),
		gmo_tibia('\uf25e'),
		gmo_tibia_alt('\uf25d'),
		gmo_time_auto('\uf25c'),
		gmo_timelapse('\uf25b'),
		gmo_timeline('\uf25a'),
		gmo_timer('\uf259'),
		gmo_timer_10('\uf258'),
		gmo_timer_10_alt_1('\uf257'),
		gmo_timer_10_select('\uf256'),
		gmo_timer_3('\uf255'),
		gmo_timer_3_alt_1('\uf254'),
		gmo_timer_3_select('\uf253'),
		gmo_timer_5('\uf252'),
		gmo_timer_5_shutter('\uf251'),
		gmo_timer_off('\uf250'),
		gmo_timer_pause('\uf24f'),
		gmo_timer_play('\uf24e'),
		gmo_tips_and_updates('\uf24d'),
		gmo_tire_repair('\uf24c'),
		gmo_title('\uf24b'),
		gmo_titlecase('\uf24a'),
		gmo_toast('\uf249'),
		gmo_toc('\uf248'),
		gmo_today('\uf247'),
		gmo_toggle_off('\uf246'),
		gmo_toggle_on('\uf245'),
		gmo_token('\uf244'),
		gmo_toll('\uf243'),
		gmo_tonality('\uf242'),
		gmo_toolbar('\uf241'),
		gmo_tools_flat_head('\uf240'),
		gmo_tools_installation_kit('\uf23f'),
		gmo_tools_ladder('\uf23e'),
		gmo_tools_level('\uf23d'),
		gmo_tools_phillips('\uf23c'),
		gmo_tools_pliers_wire_stripper('\uf23b'),
		gmo_tools_power_drill('\uf23a'),
		gmo_tools_wrench('\uf239'),
		gmo_tooltip('\uf238'),
		gmo_top_panel_close('\uf237'),
		gmo_top_panel_open('\uf236'),
		gmo_topic('\uf235'),
		gmo_tornado('\uf234'),
		gmo_total_dissolved_solids('\uf233'),
		gmo_touch_app('\uf232'),
		gmo_touchpad_mouse('\uf231'),
		gmo_touchpad_mouse_off('\uf230'),
		gmo_tour('\uf22f'),
		gmo_toys('\uf22e'),
		gmo_toys_and_games('\uf22d'),
		gmo_toys_fan('\uf22c'),
		gmo_track_changes('\uf22b'),
		gmo_trackpad_input('\uf22a'),
		gmo_traffic('\uf229'),
		gmo_traffic_jam('\uf228'),
		gmo_trail_length('\uf227'),
		gmo_trail_length_medium('\uf226'),
		gmo_trail_length_short('\uf225'),
		gmo_train('\uf224'),
		gmo_tram('\uf223'),
		gmo_transcribe('\uf222'),
		gmo_transfer_within_a_station('\uf221'),
		gmo_transform('\uf220'),
		gmo_transgender('\uf21f'),
		gmo_transit_enterexit('\uf21e'),
		gmo_transition_chop('\uf21d'),
		gmo_transition_dissolve('\uf21c'),
		gmo_transition_fade('\uf21b'),
		gmo_transition_push('\uf21a'),
		gmo_transition_slide('\uf219'),
		gmo_translate('\uf218'),
		gmo_transportation('\uf217'),
		gmo_travel('\uf216'),
		gmo_travel_explore('\uf215'),
		gmo_travel_luggage_and_bags('\uf214'),
		gmo_trending_down('\uf213'),
		gmo_trending_flat('\uf212'),
		gmo_trending_up('\uf211'),
		gmo_trip('\uf210'),
		gmo_trip_origin('\uf20f'),
		gmo_trolley('\uf20e'),
		gmo_trolley_cable_car('\uf20d'),
		gmo_trophy('\uf20c'),
		gmo_troubleshoot('\uf20b'),
		gmo_tsunami('\uf20a'),
		gmo_tsv('\uf209'),
		gmo_tty('\uf208'),
		gmo_tune('\uf207'),
		gmo_turn_left('\uf206'),
		gmo_turn_right('\uf205'),
		gmo_turn_sharp_left('\uf204'),
		gmo_turn_sharp_right('\uf203'),
		gmo_turn_slight_left('\uf202'),
		gmo_turn_slight_right('\uf201'),
		gmo_tv('\uf200'),
		gmo_tv_gen('\uf1ff'),
		gmo_tv_guide('\uf1fe'),
		gmo_tv_off('\uf1fd'),
		gmo_tv_options_edit_channels('\uf1fc'),
		gmo_tv_options_input_settings('\uf1fb'),
		gmo_tv_remote('\uf1fa'),
		gmo_tv_signin('\uf1f9'),
		gmo_tv_with_assistant('\uf1f8'),
		gmo_two_pager('\uf1f7'),
		gmo_two_wheeler('\uf1f6'),
		gmo_type_specimen('\uf1f5'),
		gmo_u_turn_left('\uf1f4'),
		gmo_u_turn_right('\uf1f3'),
		gmo_ulna_radius('\uf1f2'),
		gmo_ulna_radius_alt('\uf1f1'),
		gmo_umbrella('\uf1f0'),
		gmo_unarchive('\uf1ef'),
		gmo_undo('\uf1ee'),
		gmo_unfloat_landscape('\uf1ed'),
		gmo_unfloat_portrait('\uf1ec'),
		gmo_unfold_less('\uf1eb'),
		gmo_unfold_less_double('\uf1ea'),
		gmo_unfold_more('\uf1e9'),
		gmo_unfold_more_double('\uf1e8'),
		gmo_ungroup('\uf1e7'),
		gmo_universal_currency('\uf1e6'),
		gmo_universal_currency_alt('\uf1e5'),
		gmo_universal_local('\uf1e4'),
		gmo_unknown_2('\uf1e3'),
		gmo_unknown_5('\uf1e2'),
		gmo_unknown_7('\uf1e1'),
		gmo_unknown_document('\uf1e0'),
		gmo_unknown_med('\uf1df'),
		gmo_unlicense('\uf1de'),
		gmo_unpaved_road('\uf1dd'),
		gmo_unpublished('\uf1dc'),
		gmo_unsubscribe('\uf1db'),
		gmo_upcoming('\uf1da'),
		gmo_update('\uf1d9'),
		gmo_update_disabled('\uf1d8'),
		gmo_upgrade('\uf1d7'),
		gmo_upload('\uf1d6'),
		gmo_upload_2('\uf1d5'),
		gmo_upload_file('\uf1d4'),
		gmo_uppercase('\uf1d3'),
		gmo_urology('\uf1d2'),
		gmo_usb('\uf1d1'),
		gmo_usb_off('\uf1d0'),
		gmo_user_attributes('\uf1cf'),
		gmo_vaccines('\uf1ce'),
		gmo_vacuum('\uf1cd'),
		gmo_valve('\uf1cc'),
		gmo_vape_free('\uf1cb'),
		gmo_vaping_rooms('\uf1ca'),
		gmo_variable_add('\uf1c9'),
		gmo_variable_insert('\uf1c8'),
		gmo_variable_remove('\uf1c7'),
		gmo_variables('\uf1c6'),
		gmo_ventilator('\uf1c5'),
		gmo_verified('\uf1c4'),
		gmo_verified_user('\uf1c3'),
		gmo_vertical_align_bottom('\uf1c2');

        override val typeface: ITypeface by lazy { OutlinedGoogleMaterial }
    }
}