package org.tasks.compose.pickers

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Check
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import org.tasks.compose.components.TasksIcon

@Composable
fun CheckableIconRow(
    icon: String?,
    tint: Color,
    text: String,
    selected: Boolean,
    onClick: () -> Unit,
) {
    CheckableIconRow(
        icon = icon,
        tint = tint,
        selected = selected,
        onClick = onClick,
        content = {
            Text(
                text = text,
                style = MaterialTheme.typography.bodyMedium,
                color = MaterialTheme.colorScheme.onSurface,
            )
        }
    )
}

@Composable
fun CheckableIconRow(
    icon: String?,
    tint: Color,
    selected: Boolean,
    onClick: () -> Unit,
    content: @Composable () -> Unit,
) {
    Row(
        verticalAlignment = Alignment.CenterVertically,
        modifier = Modifier
            .fillMaxWidth()
            .clickable { onClick() }
    ) {
        TasksIcon(
            modifier = Modifier.padding(
                start = 16.dp,
                end = 32.dp,
                top = 12.dp,
                bottom = 12.dp
            ),
            label = icon,
            tint = tint,
        )
        Box(modifier = Modifier.weight(1f)) {
            content()
        }
        if (selected) {
            Icon(
                imageVector = Icons.Outlined.Check,
                contentDescription = null,
                tint = MaterialTheme.colorScheme.onSurface,
                modifier = Modifier.padding(horizontal = 16.dp, vertical = 12.dp),
            )
        } else {
            Spacer(modifier = Modifier.width(56.dp))
        }
    }
}