/*
 * Copyright (C) 2016 Sergey Solovyev
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.squareup.otto;

/**
 * Partial implementation of {@link EventHandler} containing common fields
 *
 * @author Sergey Solovyev
 */
public abstract class BaseEventHandler implements EventHandler {

  /**
   * Should this handler receive events?
   */
  private boolean valid = true;

  @Override
  public boolean isValid() {
    return valid;
  }

  @Override
  public void invalidate() {
    valid = false;
  }
}
