/**
 * Copyright (C) 2013 The Simlar Authors.
 *
 * This file is part of Simlar. (https://www.simlar.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package org.simlar.helper;

public enum CreateAccountStatus
{
	NONE(0),
	WAITING_FOR_SMS(1),
	SUCCESS(2);

	private final int mValue;

	CreateAccountStatus(final int i)
	{
		mValue = i;
	}

	public static CreateAccountStatus fromInt(final int i)
	{
		return switch (i) {
			case 1 -> WAITING_FOR_SMS;
			case 2 -> SUCCESS;
			default -> NONE;
		};
	}

	public int toInt()
	{
		return mValue;
	}
}
