package org.sensors2.pd.activities;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.core.app.NavUtils;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.view.MenuItem;
import android.widget.TextView;

import org.sensors2.pd.R;

import java.util.Objects;


public class AboutActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_about);
		String versionString = getResources().getString(R.string.app_name);
		try {
			versionString += " " + getPackageManager().getPackageInfo(getPackageName(), 0).versionName;
		} catch (PackageManager.NameNotFoundException e) {
			e.printStackTrace();
		}
		TextView nameAndVersion = findViewById(R.id.name_and_version);
		nameAndVersion.setText(versionString);
		TextView copyright = findViewById(R.id.copyright_links);
		copyright.setMovementMethod(LinkMovementMethod.getInstance());
		copyright.setText(Html.fromHtml(getResources().getString(R.string.about_copyright)));
		TextView javaOsc = findViewById(R.id.libpd_links);
		javaOsc.setMovementMethod(LinkMovementMethod.getInstance());
		javaOsc.setText(Html.fromHtml(getResources().getString(R.string.about_license_libpd)));
		TextView bugLinks = findViewById(R.id.buglinks);
		bugLinks.setMovementMethod(LinkMovementMethod.getInstance());
		bugLinks.setText(Html.fromHtml(getResources().getString(R.string.about_buglinks)));
		Objects.requireNonNull(getActionBar()).setDisplayHomeAsUpEnabled(true);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Respond to the action bar's Up/Home button
		if (item.getItemId() == android.R.id.home) {
			NavUtils.navigateUpFromSameTask(this);
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

}
