package org.sensors2.common.sensors;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorManager;
import android.nfc.NdefMessage;

import org.sensors2.common.dispatch.DataDispatcher;
import org.sensors2.common.dispatch.Measurement;

import java.util.List;

import static java.lang.Math.PI;

/**
 * Created by thomas on 05.11.14.
 */
public class SensorCommunication {
    private final SensorActivity activity;
    private final DataDispatcher dispatcher;
    private final Settings settings;
    private final SensorManager sensorManager;
    private List<Parameters> sensors;

    public SensorCommunication(SensorActivity activity) {
        this.dispatcher = activity.getDispatcher();
        this.settings = activity.getSettings();
        this.sensorManager = activity.getSensorManager();
        this.activity = activity;
    }

    public void onPause() {
        this.sensorManager.unregisterListener(this.activity);
    }

    public void onResume() {
        for (Parameters sensor : this.getSensors()) {
            this.RegisterSensor(sensor);
        }
    }

    public List<Parameters> getSensors() {
        if (sensors == null) {
            sensors = activity.GetSensors(sensorManager);
        }
        return sensors;
    }

    private void RegisterSensor(Parameters parameters) {
        if (parameters == null) {
            return;
        }
        Sensor sensor = this.sensorManager.getDefaultSensor(parameters.getSensorType());
        if (sensor == null) {
            return;
        }
        this.sensorManager.registerListener(this.activity, sensor, this.settings.getSensorRate());
    }

    public void dispatch(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == Sensor.TYPE_ORIENTATION) {
            sensorEvent.values[0] = (float) (sensorEvent.values[0] * PI / 180f);
            sensorEvent.values[1] = (float) (sensorEvent.values[1] * PI / 180f);
            sensorEvent.values[2] = (float) (sensorEvent.values[2] * PI / 180f);
        }
        this.dispatcher.dispatch(new Measurement(sensorEvent.sensor.getType(), sensorEvent.values));
    }

    public void dispatch(NdefMessage msg) {
        this.dispatcher.dispatch(new Measurement(msg));
    }
}
