package org.sensors2.osc.bluetoothSensors.sensorHandlers.models;

import org.sensors2.osc.bluetoothSensors.sensorHandlers.Helpers;

import java.util.UUID;

public class BluetoothOscData {
    private final String oscAddress;
    private final byte[] data;

    public BluetoothOscData(String deviceId, UUID gattId, byte[] data) {
        this.oscAddress = Helpers.CreateOscAddress(Helpers.urlifyMacAddress(deviceId), Helpers.getSiginicantString(gattId));
        this.data = data;
    }

    public byte[] getData() {
        return data;
    }

    public String getOscAddress() {
        return oscAddress;
    }
}
