package org.sensors2.osc.sensors;

import android.content.SharedPreferences;

import java.util.Objects;

import static androidx.appcompat.app.AppCompatDelegate.MODE_NIGHT_FOLLOW_SYSTEM;
import static androidx.appcompat.app.AppCompatDelegate.MODE_NIGHT_NO;
import static androidx.appcompat.app.AppCompatDelegate.MODE_NIGHT_YES;

/**
 * Created by thomas on 05.11.14.
 */
public class Settings extends org.sensors2.common.sensors.Settings {
    public static final String SEND_AS_BUNDLE = "pref_comm_bundle";
    public static final String KEEP_SCREEN_ALIVE = "pref_comm_screen_alive";
    public static final String PORT = "pref_comm_port";
    public static final String HOST = "pref_comm_host";
    public static final String MINIMUM_VALUE = "pref_comm_min_change";
    public static final String COLOR_SCHEME = "pref_style_color_scheme";
    public static final String LAUNCH_VERSION = "pref_version";
    public static final String DEPRECATED_TOUCH = "pref_comm_deprecated_touch";
    public static final String DEFAULT_HOST = "localhost";
    private static final String COLOR_DEFAULT = "DEFAULT";
    private static final String COLOR_LIGHT = "DAY";
    private static final String COLOR_DARK = "NIGHT";
    private final String host;
    private final int port;
    private final boolean sendAsBundle;
    private final boolean keepScreenAlive;
    private final int minimumChange;
    private final String colorScheme;
    private Boolean useDeprecatedTouch;
    private int launchVersion;

    public Settings(SharedPreferences preferences) {
        super(preferences);
        this.host = this.setHost(preferences);
        this.port = this.setPort(preferences);
        this.sendAsBundle = this.setSendAsBundle(preferences);
        this.keepScreenAlive = this.setKeepScreenAlive(preferences);
        this.minimumChange = this.setMinimumChange(preferences);
        this.colorScheme = this.setColorScheme(preferences);
        this.useDeprecatedTouch = this.setUseDeprecatedTouch(preferences);
        this.launchVersion = preferences.getInt(LAUNCH_VERSION, 0);
    }

    private String setHost(SharedPreferences preferences) {
        return preferences.getString(HOST, DEFAULT_HOST);
    }

    private int setPort(SharedPreferences preferences) {
        return Integer.parseInt(Objects.requireNonNull(preferences.getString(PORT, "9000")));
    }

    private boolean setSendAsBundle(SharedPreferences preferences) {
        return preferences.getBoolean(SEND_AS_BUNDLE, false);
    }

    private boolean setKeepScreenAlive(SharedPreferences preferences) {
        return preferences.getBoolean(KEEP_SCREEN_ALIVE, false);
    }

    private int setMinimumChange(SharedPreferences preferences) {
        return preferences.getInt(MINIMUM_VALUE, 1);
    }

    private String setColorScheme(SharedPreferences preferences) {
        return preferences.getString(COLOR_SCHEME, COLOR_DEFAULT);
    }

    private Boolean setUseDeprecatedTouch(SharedPreferences preferences) {
        return preferences.getBoolean(DEPRECATED_TOUCH, false);
    }

    public boolean getSetAsBundle() {
        return sendAsBundle;
    }

    public boolean getKeepScreenAlive() {
        return keepScreenAlive;
    }

    public int getPort() {
        return port;
    }

    public String getHost() {
        return host;
    }

    public float getMinimumChange() {
        return minimumChangeIntToFloat(minimumChange);
    }

    public static float minimumChangeIntToFloat(int minimumChange) {
        switch (minimumChange) {
            case 0:
                return 0f;
            case 1:
                return .1f;
            case 2:
                return .25f;
            case 3:
                return .5f;
            case 4:
                return 1f;
            case 5:
                return 1.5f;
            case 6:
                return 2f;
            case 7:
                return 2.5f;
            case 8:
                return 3f;
            case 9:
                return 5f;
            default:
                return minimumChange;
        }
    }

    public boolean getUseDeprecatedTouch() {
        return useDeprecatedTouch;
    }

    public int getColorScheme() {
        if (this.colorScheme.equals(COLOR_DARK)) {
            return MODE_NIGHT_YES;
        }
        if (this.colorScheme.equals(COLOR_LIGHT)) {
            return MODE_NIGHT_NO;
        }
        return MODE_NIGHT_FOLLOW_SYSTEM;
    }

    public int getLaunchVersion() {
        return launchVersion;
    }

    public void setAndSaveLaunchVersion(int launchVersion, SharedPreferences preferences) {
        this.launchVersion = launchVersion;
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(LAUNCH_VERSION, this.launchVersion);
        editor.apply();
    }
}