package org.sensors2.osc.fragments.sensorList;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import org.sensors2.osc.R;
import org.sensors2.osc.activities.StartUpActivity;
import org.sensors2.osc.dispatch.Bundling;
import org.sensors2.osc.dispatch.SensorConfiguration;
import org.sensors2.osc.dispatch.SensorService;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

public class BluetoothSensorFragment extends Fragment implements AbstractSensorFragment {
    private final SensorConfiguration sensorConfiguration;

    public BluetoothSensorFragment() {
        super();
        this.sensorConfiguration = new SensorConfiguration();
    }

    public void setSensorService(SensorService sensorService) {
    }

    public int getSensorType() {
        return this.sensorConfiguration.getSensorType();
    }

    public void deactivate() {
    }

    @SuppressLint("SetTextI18n")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        assert args != null;
        this.sensorConfiguration.setSensorType(args.getInt(Bundling.SENSOR_TYPE));
        String name = args.getString(Bundling.NAME);

        @SuppressLint("InflateParams") View v = inflater.inflate(R.layout.bt_sensor, null);

        TextView groupName = v.findViewById(R.id.group_name);
        groupName.setText(name);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) groupName.getLayoutParams();
        layoutParams.addRule(RelativeLayout.LEFT_OF, R.id.bt_button);
        groupName.setLayoutParams((layoutParams));

        TextView oscParam = v.findViewById(R.id.osc_prefix);
        oscParam.setText("/" + args.getString(Bundling.OSC_PREFIX));
        layoutParams = (RelativeLayout.LayoutParams) oscParam.getLayoutParams();
        layoutParams.addRule(RelativeLayout.LEFT_OF, R.id.bt_button);
        layoutParams.addRule(RelativeLayout.BELOW, R.id.group_name);
        oscParam.setLayoutParams((layoutParams));

        StartUpActivity activity = (StartUpActivity) getActivity();
        assert activity != null;
        activity.registerFragment(this);
        return v;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
    }
}