package org.sensors2.osc.dispatch;

import org.sensors2.osc.sensors.Parameters;

/**
 * Created by thomas on 11.11.14.
 */
public class SensorConfiguration {
    private final float[] currentValues = new float[Parameters.MAX_DIMENSIONS];
    private boolean send;
    private int sensorType;
    private String oscParam;
    private boolean sendDuplicates;
    private float minimumChange;
    private float range;

    public boolean sendingNeeded(float[] values) {
        if (!this.send) {
            return false;
        }
        if (this.sendDuplicates) {
            return true;
        }
        boolean differenceDetected = false;
        for (int i = 0; i < values.length && i < Parameters.MAX_DIMENSIONS; i++) {
            if (Math.abs(values[i] - this.currentValues[i]) > this.range * 0.01f * this.minimumChange) {
                differenceDetected = true;
            }
            if (differenceDetected) {
                this.currentValues[i] = values[i];
            }
        }
        return differenceDetected;
    }

    public boolean getSend() {
        return this.send;
    }

    public void setSend(boolean send) {
        initValues();
        this.send = send;
    }

    public void initValues() {
        this.currentValues[0] = -100f;
    }

    public void setSendDuplicates(boolean sendDuplicates) {
        this.sendDuplicates = sendDuplicates;
    }

    public int getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(int sensorType) {
        this.sensorType = sensorType;
    }

    public String getOscParam() {
        return this.oscParam;
    }

    public void setOscParam(String oscParam) {
        this.oscParam = oscParam;
    }

    public void setMinimumChange(float minimumChange) {
        this.minimumChange = minimumChange;
    }

    public void setRange(float range) {
        this.range = range;
    }
}