package org.sensors2.osc.fragments.bluetoothOverlay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.sensors2.osc.R;
import org.sensors2.osc.bluetoothSensors.sensorHandlers.models.Device;
import org.sensors2.osc.dispatch.SensorService;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;

import static org.sensors2.osc.bluetoothSensors.BluetoothConnectionManager.DEVICE_ACTION_CONTENT;
import static org.sensors2.osc.bluetoothSensors.BluetoothConnectionManager.DEVICE_ACTION_NAME;

@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public class ListFragment extends Fragment implements DeviceListAdapter.DeviceStatusCallback {
    private DeviceListAdapter listAdapter;
    private List<Device> devices = new ArrayList<>();
    private Activity activity;
    private BluetoothDeviceReceiver receiver;
    private SensorService sensorService;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.bt_overlay, container, false);
        listAdapter = new DeviceListAdapter(requireActivity(), R.layout.bt_device, devices);
        listAdapter.setNotifyOnChange(true);
        listAdapter.setDeviceStatusCallback(this);
        ListView listing = v.findViewById(R.id.device_list);
        listing.setAdapter(listAdapter);
        listing.setEmptyView(v.findViewById(R.id.empty_list));
        return v;
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        if (context instanceof Activity) {
            this.activity = (Activity) context;
        }
    }

    public void updateView(List<Device> devices){
        if (activity == null){
            return;
        }
        activity.runOnUiThread(() -> {
            this.devices = devices;
            if (listAdapter != null){
                listAdapter.clear();
                for (Device device : devices){
                    listAdapter.add(device);
                }
                listAdapter.notifyDataSetChanged();
            }
        });
    }


    public void setSensorService(SensorService sensorService) {
        this.sensorService = sensorService;
        updateView(sensorService.getBluetoothConnectionManager().getDevices());
    }

    @Override
    public void changeBluetoothDeviceStatus(String deviceAddress, boolean active) {
        if (this.sensorService != null){
            this.sensorService.getBluetoothConnectionManager().setDeviceStatus(deviceAddress, active);
        }
    }

    private class BluetoothDeviceReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            Bundle extras = intent.getExtras();
            assert extras != null;
            String serializedDevices = extras.getString(DEVICE_ACTION_CONTENT);
            final Type type = new TypeToken<ArrayList<Device>>() {
            }.getType();
            updateView(new Gson().fromJson(serializedDevices,type));
        }
    }

    @SuppressLint("UnspecifiedRegisterReceiverFlag")
    @Override
    public void onResume() {
        super.onResume();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(DEVICE_ACTION_NAME);
        if (receiver == null) {
            receiver = new BluetoothDeviceReceiver();
        }
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
            requireContext().registerReceiver(receiver, intentFilter);
        } else {
            requireContext().registerReceiver(receiver, intentFilter, Context.RECEIVER_NOT_EXPORTED);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        requireContext().unregisterReceiver(receiver);
    }
}
